//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCTOOLWINDOWBASE_H
#define DCTOOLWINDOWBASE_H

#include <QtGui>
#include <QPushButton>
#include <QDialog>

class DCCreator;

class DCToolWindowTitleBar : public QPushButton
{
    Q_OBJECT

private:
    int             d_mousePrevX;
    int             d_mousePrevY;
    int             d_dragStartX;
    int             d_dragStartY;
    QTime           d_clickTime;

public:
    DCToolWindowTitleBar(const QString &windowTitle, QWidget *parent = 0);
    virtual ~DCToolWindowTitleBar();

protected:
    virtual void mousePressEvent(QMouseEvent * event);
    virtual void mouseReleaseEvent(QMouseEvent * event);
    virtual void mouseMoveEvent(QMouseEvent * event);

signals:
    void moved(int dx, int dy);
    void expandOrCollapse();
    void dragMoveFinished();

private slots:

};


class DCToolWindowBase : public QDialog
{
    Q_OBJECT

private:
    QVBoxLayout             *d_layout;
    DCToolWindowTitleBar    *d_titleButton;
    bool                    d_collapsed;
    QRect                   d_rect;
    int                     d_titleButtonHeight;
    DCCreator               *d_creator;

public:
    DCToolWindowBase(const QString &windowTitle, DCCreator *creator);
    virtual ~DCToolWindowBase();

    DCCreator*      getController() const { return d_creator; }
    int             getTitleButtonHeight() const { return d_titleButtonHeight; }
    virtual int     getPosPriority() const = 0;
    bool            getIsOnStage() const { return graphicsProxyWidget() != NULL; }
    QVBoxLayout*    contentLayout() { return d_layout; }

    void            setButtonedWindowTitle(const QString &title);
    void            doAnimation() { emit doAnimationInToolWindow(); }

protected:
    virtual void resizeEvent(QResizeEvent *event);

private slots:
    void slotMoveWindow(int dx,int dy);
    void slotExpandOrCollapse();
    void slotDragModeFinished();

signals:
    void dragMoveFinished();
    void doAnimationInToolWindow();
};


#endif // DCTOOLWINDOWBASE_H
