//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#include "dceditabletreeview.h"

const static QString NORMALSTYLE =
        "       QTreeView {"
        "           background-color: rgba(0,0,0,50);"
        "           show-decoration-selected: 1;"
        "        }"

        "        QTreeView::item {"
        "            border: none;"
        "        }"

        "        QTreeView::item:hover {"
        "            background: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1 stop: 0 #6ea1f1, stop: 1 #567dbc);"
        "            border: none;"
        "        }"

        "        QTreeView::item:selected {"
        "            border: 1px solid #567dbc;"
        "        }"

        "        QTreeView::item:selected:active{"
        "            background: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #6ea1f1, stop: 1 #567dbc);"
        "        }"

        "        QTreeView::item:selected:!active {"
        "            background: rgba(0,0,0,0);"
        "            color: white;"
        "        }"

        "        QLineEdit {"
        "           background: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1,stop: 0 rgb(0,0,0), stop: 0.3 rgb(40,40,40), stop: 1.0 rgb(40,40,40));"
        "           border: none; text-align:left; padding: 0 4px;}";


DCEditableTreeView::DCEditableTreeView(QWidget *parent) :
    QTreeView(parent), d_maximumVisibleRow(8)
{
    setMinimumSize(10,10);
    setStyleSheet(NORMALSTYLE);
    ScrollBar *vscrollbar = new ScrollBar;
    setVerticalScrollBar(vscrollbar);
    connect(vscrollbar, SIGNAL(shown()), this, SLOT(slotVScrollbarShown()));
    connect(vscrollbar, SIGNAL(hidden()), this, SLOT(slotVScrollbarHidden()));
}

DCEditableTreeView::~DCEditableTreeView()
{

}

int DCEditableTreeView::calculateHeight(const QModelIndex &parent) const
{
    QAbstractItemModel *pModel = model();

    int totalHeight = 0;
    if (pModel)
    {
        int len = pModel->rowCount(parent);
        len = len < d_maximumVisibleRow ? len : d_maximumVisibleRow;

        for (int i = 0; i < len ; i++)
        {
            QModelIndex itemIndex = pModel->index(i,0,parent);
            if (!isRowHidden(i,parent))
                totalHeight += rowHeight(itemIndex);

            totalHeight += calculateHeight(itemIndex);
        }
    }
    return totalHeight;
}

QSize DCEditableTreeView::sizeHint() const
{
    QSize size = QTreeView::sizeHint();
    if (!isHeaderHidden())
        size.setHeight(header()->frameSize().height() + calculateHeight() + 4);
    else
        size.setHeight(calculateHeight() + 4);

    return size;
}

void DCEditableTreeView::slotVScrollbarShown()
{
    emit vscrollbarShown();
}

void DCEditableTreeView::slotVScrollbarHidden()
{
    emit vscrollbarHidden();
}
