//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#include "dceditablelabel.h"

#include "dctoolwindowbase.h"
#include "dcglvisualizerwidget.h"

#include <QMouseEvent>

static const QString HOVERSTYLE =
        "background: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1,stop: 0 rgb(80,80,80), stop: 0.3 rgb(120,128,120), stop: 0.9 rgb(120,128,120), stop: 1.0 rgb(80,80,80));"
        "border: 1px solid rgb(100,100,100); text-align:left; padding: 0 4px;";

static const QString NORMALSTYLE =
        "background: rgb(80,80,80); border: 1px solid rgb(100,100,100); text-align:left; padding: 0 4px;";

static const QString EDITSTYLE =
        "background: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1,stop: 0 rgb(0,0,0), stop: 0.3 rgb(40,40,40), stop: 1.0 rgb(40,40,40));"
        "border: 1px solid rgb(80,80,80); text-align:left; padding: 0 4px;";

DCEditableLabel::DCEditableLabel(DCToolWindowBase *parent, const QString &text) :
    QLineEdit(text), d_parent(parent), d_mouseOver(false)
{
    setReadOnly(true);
    setStyleSheet(NORMALSTYLE);
    setMouseTracking(true);
    connect(parent, SIGNAL(doAnimationInToolWindow()), this, SLOT(doAnimation()));
    connect(this, SIGNAL(editingFinished()), this, SLOT(slotEditingFinished()));
}

DCEditableLabel::~DCEditableLabel()
{
    d_parent->disconnect(this);
}

void DCEditableLabel::doAnimation()
{
    if (d_mouseOver)
    {
        QPoint p = mapFromGlobal(DCGLVisualizerWidget::globalPointToLocal(QCursor::pos()).toPoint());
        if ( p.x() < 0 || p.x() > width() || p.y() < 0 || p.y() > height())
        {
            d_mouseOver = false;
            setStyleSheet(NORMALSTYLE);
        }
    }
}

void DCEditableLabel::mouseDoubleClickEvent(QMouseEvent *event)
{
    QLineEdit::mouseDoubleClickEvent(event);
    setStyleSheet(EDITSTYLE);
    setReadOnly(false);
    selectAll();
    d_mouseOver = false;
}

void DCEditableLabel::mouseMoveEvent(QMouseEvent *event)
{
    QLineEdit::mouseMoveEvent(event);
    QPoint p = event->pos();

    if ( isReadOnly() && p.x() > 0 && p.x() < width() && p.y() > 0 && p.y() < height())
    {
        if (!d_mouseOver)
        {
            d_mouseOver = true;
            setStyleSheet(HOVERSTYLE);
        }
    }
}

void DCEditableLabel::labelButtonClicked()
{
}

void DCEditableLabel::slotEditingFinished()
{
    setReadOnly(true);
    setStyleSheet(NORMALSTYLE);
}
