//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Oct-15, 2012.
//

#include "dccelltypecombobox.h"

#include "dccreator.h"
#include "dccontainer.h"
#include "dccell.h"

DCCellTypeComboBox::DCCellTypeComboBox(DCCreator *creator, QWidget *parent) :
    QComboBox(parent), d_creator(creator), d_cell(NULL)
{
    addItems(QStringList(creator->getCurrentContainer()->getAvailableCellTypes()));
    connect(this, SIGNAL(currentIndexChanged(QString)), this, SLOT(slotCurrentIndexChanged(QString)));
}

DCCellTypeComboBox::~DCCellTypeComboBox()
{

}

void DCCellTypeComboBox::changeType(const QString &newType)
{
    for (int i = 0; i < count(); i++)
    {
        if (itemText(i) == newType)
        {
            setCurrentIndex(i);
            break;
        }
    }
}

void DCCellTypeComboBox::setEditingCell(DCCell *cell)
{
    d_cell = cell;
    updateSelection();
}

void DCCellTypeComboBox::updateSelection()
{
    if (d_cell)
    {
        changeType(d_cell->getType());
    }
}

void DCCellTypeComboBox::slotCurrentIndexChanged(const QString &newType)
{
    DCContainer *container = d_creator->getCurrentContainer();

    if (d_cell->getType() != newType)
    {
        bool isCurrentScriptable = container->getIsScriptable(d_cell->getType());
        bool isNewScriptable = container->getIsScriptable(newType);
        if (isCurrentScriptable && !isNewScriptable)
        {
            int r = QMessageBox::warning(NULL, tr("Change cell type"),
                                 tr("This cell type doesn't support cell code scripts. All script attached to this cell will be removed when you change this type. Do you proceed?"),
                                 QMessageBox::Ok | QMessageBox::Cancel, QMessageBox::Cancel);
            if (r == QMessageBox::Cancel)
            {
                changeType(d_cell->getType());
                return;
            }
        }
        d_creator->doCommandChangeCellType(this, d_cell, newType);
    }
    emit typeChanged(newType);
}
