//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#include "dcselectionrenderer.h"

#include <QtOpenGL>

static const double PI = 3.14159265358979323846264338327950288419717;

DCSelectionRenderer::DCSelectionRenderer(float lineWidth, float gap)
    : d_rectSize(0), d_lineWidth(lineWidth), d_gap(gap), d_offset(0),
      d_strokeLen(0), d_strokePosition(0)

{
    d_roundEdgeDistanceRadius = d_lineWidth * 0.5;
    d_roundEdgeStep = PI / 10 * d_roundEdgeDistanceRadius;
    d_lineWidth2 = d_lineWidth * 0.5;
}

DCSelectionRenderer::~DCSelectionRenderer()
{

}

void DCSelectionRenderer::setRectSize(float rectSize)
{
    d_rectSize = rectSize;
    d_strokeLen = d_rectSize - d_lineWidth * 2;
    d_strokePosition = d_rectSize/2;
}

void DCSelectionRenderer::draw(bool isAnimationInterval)
{
    if (d_rectSize <= 0)
    {
        return;
    }

    float strokeLenHalf = d_strokeLen / 2;
    float roundEdgelen = d_roundEdgeDistanceRadius * PI / 2;

    float totalLen = d_strokeLen * 4 + roundEdgelen * 4;
    int gaps = totalLen / (d_gap * 2);
    float adj = (totalLen - (gaps * d_gap * 2)) / gaps;

    float d = d_offset;
    float gap = d_gap - adj * 2;

    glBegin(GL_TRIANGLE_STRIP);

    bool c = true;
    while (d <= d_strokeLen)
    {
        glVertex3f(strokeLenHalf - d, 0, -d_strokePosition + d_lineWidth);
        glVertex3f(strokeLenHalf - d, 0, -d_strokePosition);

        if (c)
            glColor3f(1,1,1);
        else
            glColor3f(0,0,0);

        glVertex3f(strokeLenHalf - d, 0, -d_strokePosition + d_lineWidth);
        glVertex3f(strokeLenHalf - d, 0, -d_strokePosition);

        d += gap;
        c = !c;
    }

    //round edge1
    c = !c;
    bool nc = c;
    float nextGap = d - d_strokeLen;
    d = 0;
    while(d <= roundEdgelen)
    {
        float rad = d / d_roundEdgeDistanceRadius;
        float rx = d_lineWidth * cos(rad);
        float ry = d_lineWidth * sin(rad);
        glVertex3f(-strokeLenHalf, 0, -d_strokePosition + d_lineWidth);
        glVertex3f(-strokeLenHalf - ry, 0, -d_strokePosition + d_lineWidth - rx);
        if (nc != c)
        {
            c = nc;
            if (c)
                glColor3f(1,1,1);
            else
                glColor3f(0,0,0);
            glVertex3f(-strokeLenHalf, 0, -d_strokePosition + d_lineWidth);
            glVertex3f(-strokeLenHalf - ry, 0, -d_strokePosition + d_lineWidth - rx);
        }
        d += d_roundEdgeStep;
        if (nextGap < d && nextGap < roundEdgelen)
        {
            d = nextGap;
            nc = !c;
            nextGap += gap;
        }
    }
    d = nextGap - roundEdgelen;
    c = !c;
    glVertex3f(-d_strokePosition + d_lineWidth, 0, -strokeLenHalf );
    glVertex3f(-d_strokePosition , 0, - strokeLenHalf );
    //

    while (d < d_strokeLen)
    {
        glVertex3f(-d_strokePosition + d_lineWidth, 0, -strokeLenHalf + d);
        glVertex3f(-d_strokePosition , 0, - strokeLenHalf + d);
        if (c)
            glColor3f(1,1,1);
        else
            glColor3f(0,0,0);
        glVertex3f(-d_strokePosition + d_lineWidth, 0, -strokeLenHalf + d);
        glVertex3f(-d_strokePosition , 0, - strokeLenHalf + d);

        d += gap;
        c = !c;
    }

    //round edge2
    c = !c;
    nc = c;
    nextGap = d - d_strokeLen;
    d = 0;
    while(d <= roundEdgelen)
    {
        float rad = d / d_roundEdgeDistanceRadius;
        float rx = d_lineWidth * cos(rad);
        float ry = d_lineWidth * sin(rad);
        glVertex3f(-d_strokePosition + d_lineWidth, 0, strokeLenHalf );
        glVertex3f(-d_strokePosition + d_lineWidth - rx, 0, strokeLenHalf + ry);
        if (nc != c)
        {
            c = nc;
            if (c)
                glColor3f(1,1,1);
            else
                glColor3f(0,0,0);
            glVertex3f(-d_strokePosition + d_lineWidth, 0, strokeLenHalf );
            glVertex3f(-d_strokePosition + d_lineWidth - rx, 0, strokeLenHalf + ry);
        }
        d += d_roundEdgeStep;
        if (nextGap < d && nextGap < roundEdgelen)
        {
            d = nextGap;
            nc = !c;
            nextGap += gap;
        }
    }
    d = nextGap - roundEdgelen;
    c = !c;
    glVertex3f(-strokeLenHalf, 0, d_strokePosition - d_lineWidth);
    glVertex3f(-strokeLenHalf, 0, d_strokePosition);

    //

    while (d < d_strokeLen)
    {
        glVertex3f(-strokeLenHalf + d, 0, d_strokePosition - d_lineWidth);
        glVertex3f(-strokeLenHalf + d, 0, d_strokePosition);

        if (c)
            glColor3f(1,1,1);
        else
            glColor3f(0,0,0);
        glVertex3f(-strokeLenHalf + d, 0, d_strokePosition - d_lineWidth);
        glVertex3f(-strokeLenHalf + d, 0, d_strokePosition);

        d += gap;
        c = !c;
    }

    //round edge3
    c = !c;
    nc = c;
    nextGap = d - d_strokeLen;
    d = 0;
    while(d <= roundEdgelen)
    {
        float rad = d / d_roundEdgeDistanceRadius;
        float rx = d_lineWidth * cos(rad);
        float ry = d_lineWidth * sin(rad);
        glVertex3f(strokeLenHalf , 0, d_strokePosition - d_lineWidth );
        glVertex3f(strokeLenHalf + ry, 0, d_strokePosition - d_lineWidth + rx);
        if (nc != c)
        {
            c = nc;
            if (c)
                glColor3f(1,1,1);
            else
                glColor3f(0,0,0);
            glVertex3f(strokeLenHalf , 0, d_strokePosition - d_lineWidth );
            glVertex3f(strokeLenHalf + ry, 0, d_strokePosition - d_lineWidth + rx);
        }
        d += d_roundEdgeStep;
        if (nextGap < d && nextGap < roundEdgelen)
        {
            d = nextGap;
            nc = !c;
            nextGap += gap;
        }
    }
    d = nextGap - roundEdgelen;
    c = !c;

    glVertex3f(d_strokePosition - d_lineWidth, 0, strokeLenHalf);
    glVertex3f(d_strokePosition, 0, strokeLenHalf);

    while (d < d_strokeLen)
    {
        glVertex3f(d_strokePosition - d_lineWidth, 0, strokeLenHalf - d);
        glVertex3f(d_strokePosition, 0, strokeLenHalf - d);
        if (c)
            glColor3f(1,1,1);
        else
            glColor3f(0,0,0);
        glVertex3f(d_strokePosition - d_lineWidth, 0, strokeLenHalf - d);
        glVertex3f(d_strokePosition, 0, strokeLenHalf - d);

        d += gap;
        c = !c;
    }

    //round edge4
    c = !c;
    nc = c;
    nextGap = d - d_strokeLen;
    d = 0;
    while(d <= roundEdgelen)
    {
        float rad = d / d_roundEdgeDistanceRadius;
        float rx = d_lineWidth * cos(rad);
        float ry = d_lineWidth * sin(rad);
        glVertex3f(d_strokePosition - d_lineWidth , 0, -strokeLenHalf );
        glVertex3f(d_strokePosition - d_lineWidth + rx, 0, -strokeLenHalf - ry);
        if (nc != c)
        {
            c = nc;
            if (c)
                glColor3f(1,1,1);
            else
                glColor3f(0,0,0);
            glVertex3f(d_strokePosition - d_lineWidth , 0, -strokeLenHalf );
            glVertex3f(d_strokePosition - d_lineWidth + rx, 0, -strokeLenHalf - ry);
        }
        d += d_roundEdgeStep;
        if (nextGap < d && nextGap < roundEdgelen)
        {
            d = nextGap;
            nc = !c;
            nextGap += gap;
        }
    }
    d = nextGap - roundEdgelen;


    glVertex3f(d_strokePosition - d_lineWidth , 0, -strokeLenHalf );
    glVertex3f(d_strokePosition - d_lineWidth, 0, -d_strokePosition);

    glVertex3f(strokeLenHalf - d, 0, -d_strokePosition + d_lineWidth);
    glVertex3f(strokeLenHalf - d, 0, -d_strokePosition);

    glEnd();

    glBegin(GL_QUADS);
    d = 0;
    c = false;
    for (int i = 0; i < 6; i ++)
    {
        if (c)
            glColor3f(1,1,1);
        else
            glColor3f(0,0,0);
        glVertex3f(strokeLenHalf - d_lineWidth2 - d , 0.001f, strokeLenHalf);
        glVertex3f(strokeLenHalf - d, 0.001f, strokeLenHalf);
        glVertex3f(strokeLenHalf, 0.001f, strokeLenHalf - d);
        glVertex3f(strokeLenHalf, 0.001f, strokeLenHalf - d_lineWidth2 - d);

        d += d_lineWidth2;
        c = !c;
    }
    glEnd();

    if (isAnimationInterval)
    {
        d_offset += (gap / 3);
        if (d_offset >= gap * 2)
        {
            d_offset -= (gap * 2);
        }
    }
}

bool DCSelectionRenderer::isResizingArea(float x, float y)
{
    float strokeLenHalf = d_strokeLen / 2;
    float x0 = strokeLenHalf - d_lineWidth2 * 6;
    float y0 = strokeLenHalf;
    float x1 = strokeLenHalf;
    float y1 = strokeLenHalf - d_lineWidth2 * 6;

    return (x0 <= x && x <= x1 && y1 <= y && y <= y0 && -(x - x0) + y0 < y);
}
