//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#include "dcvcreceptor.h"

#include "dcvcomponent.h"
#include "dcaxonterminal.h"
#include "dccell.h"

#include "dcreceptor.h"
#include "dccontainer.h"

#include "dcvceditmodecursor.h"

#include <QtOpenGL>

DCVCReceptor::DCVCReceptor(DCReceptor *owner)  : d_owner(owner), d_matrixUpdated(false), d_size(0.1f)
{
}

void DCVCReceptor::prepareChildrenForDraw(bool isAnimationInterval)
{
    float matrix[16];
    glGetFloatv(GL_MODELVIEW_MATRIX, matrix);

    DCVComponent *vterminal = getTerminalComponent();
    if (vterminal)
    {
        d_owner->getTarget()->setViewMatrixForReceptorPoint(matrix);
        vterminal->prepareForDraw(isAnimationInterval);
    }
    if (d_owner->hasEditCursor())
    {
        d_owner->setEditingCursorViewMatrix(matrix);
    }
}

void DCVCReceptor::drawChildren(bool isAnimationInterval)
{
    DCVComponent *vterminal = getTerminalComponent();
    if (vterminal)
    {
        vterminal->draw(isAnimationInterval);
    }
}

void DCVCReceptor::drawChildrenForSelection(QList<DCVComponent *> *itemList)
{
    DCVComponent *vterminal = getTerminalComponent();
    if (vterminal)
    {
        vterminal->drawForSelection(itemList);
    }
}

void DCVCReceptor::translate()
{
    glTranslatef(0, -0.245f, 0);
}

void DCVCReceptor::setSelected(bool selected, bool updateChildren)
{
    DCVComponent::setSelected(selected,updateChildren);

    DCVComponent *vterminal = getTerminalComponent();
    if (updateChildren)
    {
        if (vterminal)
        {
            vterminal->setSelected(selected, true);
        }
    }
}

void DCVCReceptor::setVisible(DCVVisibility visibleSelf, DCVVisibility visibleChildren)
{
    DCVComponent::setVisible(visibleSelf, visibleChildren);
    d_owner->setTerminalVisible(visibleChildren != DCV_VISIBLE_NONE);
}

void DCVCReceptor::renderOwnShape(bool isAnimationInterval, bool renderAsWireframe)
{
    (void)isAnimationInterval; (void)renderAsWireframe;
    //TODO
}

DCVComponent* DCVCReceptor::getTerminalComponent() const
{
    DCAxonTerminal *terminal = d_owner->getTarget();
    if (terminal)
    {
        return terminal->getVComponent();
    }
    else
    {
        return NULL;
    }
}

bool DCVCReceptor::isMatrixUpdated() const
{
    return d_matrixUpdated;
}

const float* DCVCReceptor::getPointMatrix() const
{
    return &d_matrix[0];
}

DCCell* DCVCReceptor::getOwnerCell() const
{
    return d_owner->getOwnerCell();
}

DCVCPage* DCVCReceptor::getPageBelonging() const
{
    return getOwnerCell()->getPageBelonging();
}

bool DCVCReceptor::startDrag(float x, float y, float z, bool isResizingDrag)
{
    (void)x; (void)y; (void)z; (void)isResizingDrag;
    return false;
}

bool DCVCReceptor::dragging(float x, float y, float z, bool isResizingDrag)
{
    (void)x; (void)y; (void)z; (void)isResizingDrag;
    return false;
}

bool DCVCReceptor::endDrag(float x, float y, float z, bool isResizingDrag)
{
    (void)x; (void)y; (void)z; (void)isResizingDrag;
    return false;
}

void DCVCReceptor::saveAttributesToXML(QDomDocument *document, QDomElement* element) const
{
    (void)document; (void)element;
}

void DCVCReceptor::loadAttributesFromXML(QDomElement element)
{
    (void)element;
}
