//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCVCEDITMODETERMINAL_H
#define DCVCEDITMODETERMINAL_H

#include "dcvcomponent.h"

class DCReceptor;

class DCVCEditModeTerminal : public DCVComponent
{
    bool    d_isViewReceptorPointUpdated;
    bool    d_isViewAxonPointUpdated;
    bool    d_isRendered;
    float   d_viewAxonPointMatrix[16];
    float   d_viewReceptorPointMatrix[16];
    DCReceptor *d_receptor;

public:
    DCVCEditModeTerminal();
    virtual ~DCVCEditModeTerminal();

    bool            getIsViewAxonPointUpdated() const { return d_isViewAxonPointUpdated; }
    bool            getIsViewReceptorPointUpdated() const { return d_isViewReceptorPointUpdated; }
    const float*    getViewAxonPointMatrix() const { return d_viewAxonPointMatrix; }
    const float*    getViewReceptorPointMatrix() const { return d_viewReceptorPointMatrix; }

    void            setViewMatrixForAxonPoint(const float matrix[16]);
    void            setViewMatrixForReceptorPoint(DCReceptor *receptor, const float matrix[16]);
    void            resetViewPoinMatrices();

    virtual DCVCPage*   getPageBelonging() const { return NULL; }
    virtual DCCell*     getOwnerCell() const;
    virtual bool        isResizingArea(float x, float y, float z) const;

    virtual void    prepareChildrenForDraw(bool isAnimationInterval);
    virtual void    drawChildren(bool isAnimationInterval);
    virtual void    drawChildrenForSelection(QList<DCVComponent*> *itemList);
    virtual void    translate();
    virtual void    renderOwnShape(bool isAnimationInterval, bool renderAsWireframe);

    virtual bool    startDrag(float x, float y, float z, bool isResizingDrag);
    virtual bool    dragging(float x, float y, float z, bool isResizingDrag);
    virtual bool    endDrag(float x, float y, float z, bool isResizingDrag);

    virtual void    updateShape();

    virtual void    saveAttributesToXML(QDomDocument *document, QDomElement* element) const {(void)document; (void)element; }
    virtual void    loadAttributesFromXML(QDomElement element) { (void)element; }

};

#endif // DCVCEDITMODETERMINAL_H
