//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCVCEDIRMODECURSOR_H
#define DCVCEDIRMODECURSOR_H

#include "dcvpagecomponent.h"

class DCCell;
class DCAxon;
class DCReceptor;
class DCVCPage;
class DCVCEditModeTerminal;

#include <QObject>

class DCVCEditModeCursor : public QObject, public DCVPageComponent
{
    Q_OBJECT

public:
    enum DCVEditCursorType { DCV_CURSOR_NONE, DCV_CURSOR_FROM_AXON, DCV_CURSOR_FROM_RECEPTAOR};

private:
    DCCell               *d_ownerCell;
    DCAxon               *d_ownerAxon;
    DCReceptor           *d_ownerReceptor;
    DCVEditCursorType    d_cursorType;
    DCVCEditModeTerminal *d_terminal;
    DCVComponent         *d_dropTarget;
    float                d_dragOffsetX;
    float                d_dragOffsetY;
    bool                 d_isDragging;

public:
    DCVCEditModeCursor();
    virtual ~DCVCEditModeCursor();

    virtual DCCell*         getOwnerCell() const { return d_ownerCell; }
    virtual bool            isResizingArea(float x, float y, float z) const;
    DCVCEditModeTerminal*   getTerminal() const { return d_terminal; }
    bool                    getIsDragging() const { return d_isDragging; }
    DCVComponent*           getDropTarget() const { return d_dropTarget; }

    void    setOwnerFromAxon(DCAxon *owner);
    void    setOwnerFromReceptor(DCReceptor *owner);
    void    setDropTarget(DCVComponent *dropTarget);
    void    unsetCursor();

    virtual void    changePageBelonging(DCVCPage *page);
    virtual void    prepareChildrenForDraw(bool isAnimationInterval);
    virtual void    drawChildren(bool isAnimationInterval);
    virtual void    drawChildrenForSelection(QList<DCVComponent*> *itemList);
    virtual void    translate();
    virtual void    renderOwnShape(bool isAnimationInterval, bool renderAsWireframe);

    virtual bool    startDrag(float x, float y, float z, bool isResizingDrag);
    virtual bool    dragging(float x, float y, float z, bool isResizingDrag);
    virtual bool    endDrag(float x, float y, float z, bool isResizingDrag);

    virtual void    updateShape();

    virtual void    saveAttributesToXML(QDomDocument *document, QDomElement* element) const{(void)document; (void)element; }
    virtual void    loadAttributesFromXML(QDomElement element) { (void)element; }

signals:
    void pageBelongingChanged(DCVCPage *currentPage);
    void dropTargetChanged(DCVComponent *currentTarget);
};

#endif // DCVCEDIRMODECURSOR_H
