//  Copyright (c) 2013 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 1/29/2013.
//

#include "dnplugininfo.h"
#include "DNUtils.h"

DNPluginInfo::DNPluginInfo()
{
    isValid = false;
}

DNPluginInfo::DNPluginInfo(const DNPluginInfo &other)
{
    isValid = other.isValid;
    pluginName = other.pluginName;
    pluginValueName = other.pluginValueName;
}

//static
DNPluginInfo DNPluginInfo::create(const std::string &name)
{
    DNPluginInfo result;
    unsigned int idx = name.find("@");
    if (idx != std::string::npos && idx > 0 && idx + 1 < name.length())
    {
        result.isValid = true;
        result.pluginValueName = name.substr(0,idx);
        result.pluginName = name.substr(name.find_last_of("@")+1);
    }

    return result;
}
