//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 12/11/2011.
//

#ifndef __INCLUDE_TKCELL__
#define __INCLUDE_TKCELL__

#include <string>
#include <map>

class TKCellCode;
class TKReceptor;
class TKAxon;
class TKContainer;
class TKCellCodeInstance;

typedef std::map<std::string, TKReceptor*> TKReceptorMap;

class TKCell
{
public:
    TKCell(TKContainer *container, std::string location, std::string name, bool canInterfaceIn, bool canInterfaceOut);
    virtual ~TKCell();

    void init();

    std::string             getName() const { return mName; }
    float                   getAxonValue() const;
    void                    setAxonValue(float value);

    const TKReceptorMap*    getReceptors() const { return &mReceptors; }

    virtual bool            setCellCode(TKCellCode *code, const void *data);

    bool                    connectTo(std::string connectionName, TKCell *targetReceptor);
    inline TKContainer*     getContainer() const { return mContainer; }
    bool                    canInterfaceIn() { return mCanInterfaceIn; }
    bool                    canInterfaceOut() { return mCanInterfaceOut; }

    bool                    enterDoTick(float time, bool forceUpdate);
    virtual bool            doTick(float time) = 0;
    virtual bool            doInit() = 0;
    virtual bool            doDestroy() = 0;
    virtual void            updateReceptorValue();

protected:
    virtual TKReceptor*     createReceptor(std::string name);

    std::string             mName;
    std::string             mLocation;
    TKContainer             *mContainer;
    TKAxon                  *mAxon;
    TKReceptorMap           mReceptors;
    TKCellCodeInstance      *mCellCodeInstance;
    bool                    mCanInterfaceIn;
    bool                    mCanInterfaceOut;
    bool                    mReceptorValueUpdated;

};

#endif

