//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 12/11/2011.
//

#ifndef __INCLUDE_TKAXONTERMINAL__
#define __INCLUDE_TKAXONTERMINAL__

class TKAxon;
class TKReceptor;

class TKAxonTerminal
{
public:
	TKAxonTerminal(TKAxon *theOwner) : mOwner(theOwner), mTarget(0) {}
    virtual ~TKAxonTerminal() {}

    void    setTarget(TKReceptor *theReceptor) {mTarget = theReceptor;}
    void    release(TKReceptor *receptor);
    
    bool    isConnected() { return mTarget != 0; }
    TKAxon* getOwner() { return mOwner; }
    float   getValue();
	
protected:
	TKAxon      *mOwner;
	TKReceptor  *mTarget;

};

#endif
