//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Oct-28, 2012.
//
#include "dcinputnewcontentdirdialog.h"

#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QGridLayout>
#include <QLabel>
#include <QFileDialog>

DCInputNewContentDirDialog::DCInputNewContentDirDialog(const QString& dir, QWidget *parent) :
    QDialog(parent), d_ok(false)
{
    setWindowTitle("New content");
    QBoxLayout *rootLayout = new QVBoxLayout;
    QGridLayout *glayout = new QGridLayout;
    glayout->addWidget(new QLabel(tr("Name:")), 0,0);
    glayout->addWidget(new QLabel(tr("Path:")),1,0);

    d_name = new QLineEdit;
    d_path = new QLineEdit(dir);
    d_path->setReadOnly(true);
    d_chooseDir = new QPushButton(tr("Reference..."));
    d_message = new QLabel();
    d_message->setStyleSheet("color:red;");

    glayout->addWidget(d_name, 0,1,1,2);
    glayout->addWidget(d_path,1,1);
    glayout->addWidget(d_chooseDir, 1,2);

    QHBoxLayout *hlayout = new QHBoxLayout;
    hlayout->addStretch();
    d_okButton = new QPushButton(tr("OK"));
    d_cancelButton = new QPushButton(tr("Cancel"));

    hlayout->addWidget(d_okButton);
    hlayout->addWidget(d_cancelButton);

    rootLayout->addLayout(glayout);
    rootLayout->addWidget(d_message);
    rootLayout->addLayout(hlayout);

    setLayout(rootLayout);

    QFont font;
    QFontMetrics fm(font);
    setMinimumWidth(fm.width("AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"));

    checkInput();

    d_name->setFocus();

    connect(d_chooseDir, SIGNAL(clicked()), this, SLOT(chooseDirectory()));
    connect(d_okButton, SIGNAL(clicked()), this, SLOT(okClicked()));
    connect(d_cancelButton, SIGNAL(clicked()), this, SLOT(close()));
    connect(d_name, SIGNAL(textChanged(QString)), this, SLOT(checkInput()));
}

DCInputNewContentDirDialog::~DCInputNewContentDirDialog()
{

}

QString DCInputNewContentDirDialog::getResult() const
{
    if (d_ok)
    {
        return d_path->text() + "/" + d_name->text();
    }
    else
    {
        return "";
    }
}

void DCInputNewContentDirDialog::chooseDirectory()
{
    QString dir = QFileDialog::getExistingDirectory(this, tr("Choose directory"), d_path->text());
    if (!dir.isEmpty())
    {
        d_path->setText(dir);
    }
    checkInput();
}

void DCInputNewContentDirDialog::checkInput()
{
    if (d_name->text().length() > 0)
    {
        QFileInfo fileInfo = QFileInfo(d_path->text() + "/" + d_name->text());
        if (fileInfo.exists())
        {
            d_okButton->setEnabled(false);
            d_cancelButton->setDefault(true);
            d_message->setText(tr("Name exists. Choose another name."));
        }
        else
        {
            d_okButton->setEnabled(true);
            d_okButton->setDefault(true);
            d_message->setText("");
        }
    }
    else
    {
        d_okButton->setEnabled(false);
        d_cancelButton->setDefault(true);
        d_message->setText(tr("Input content name (which is the root directory of the content)"));
    }
}

void DCInputNewContentDirDialog::okClicked()
{
    d_ok = true;
    close();
}
