//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#include "dccellcode.h"

#include "dcvccellcode.h"
#include "dccontainer.h"
#include "utils/dcutil.h"

DCCellCode::DCCellCode(DCContainer *container, std::string theName, std::string theCellAPIName)
    : TKCellCode(theName, theCellAPIName), d_container(container)
{
}

DCCellCode::~DCCellCode()
{
}

QString DCCellCode::getOwnScript() const
{
    return d_container->readCellCodeScriptFromFile(this);
}

QString DCCellCode::getWorkFilePathForCellCodeScript() const
{
    DCContainer *container = dynamic_cast<DCContainer*>(getContainer());
    if (container)
    {
        return container->getWorkFilePathForCellCode(this);
    }
    return "";
}

bool DCCellCode::saveScript(const QString &script)
{
    return d_container->saveClassScriptToWorkFile(this, script.toStdString());
}

DCVCPage* DCCellCode::getPageBelonging() const
{
    return d_vComponent->getPageBelonging();
}

void DCCellCode::changeName(const QString &newName)
{
    QString fqnString = DCUtil::getFQNPath(getPageBelonging()->getLocationPath(), newName);
    mFQNName = fqnString.toStdString();
}

void DCCellCode::changePath(const QString& newPath)
{
    QString name = DCUtil::getNameFromFQNPath(QString::fromStdString(mFQNName));
    QString fqnString = DCUtil::getFQNPath(newPath, name);
    mFQNName = fqnString.toStdString();
}

void DCCellCode::changeType(const QString &newType)
{
    mCellAPIName = newType.toStdString();
}

