//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCAXON_H
#define DCAXON_H

#include "TKAxon.h"

class DCCell;
class DCAxonTerminal;
class DCVComponent;
class DCVCEditModeCursor;

class DCAxon : public TKAxon
{
    friend struct DCComponentUtil;

    DCAxon(DCCell *theOwner);
    void bindComponent(DCVComponent *component);

    DCCell              *d_ownerCell;
    DCVComponent        *d_vComponent;
    float               d_viewLength;
    float               d_viewAngle;
    bool                d_isTerminalVisible;
    DCVCEditModeCursor  *d_editCursor;

public:
    virtual ~DCAxon();

    DCVComponent *      getVComponent() const { return d_vComponent; }
    inline int          getNumberOfTerminals() const { return mTerminals.size(); }
    DCAxonTerminal*     getTerminalAt(int i) const;
    DCCell*             getOwnerCell() const;
    float               getViewLength() const;
    float               getViewAngle() const;
    bool                getIsTerminalVisible() const { return d_isTerminalVisible; }

    bool                hasEditingTerminal() const;
    DCVComponent*       getEditingTerminal() const;

    void                setViewLength(float length);
    void                setViewAngle(float angle);
    void                setTerminalVisible(bool visible) { d_isTerminalVisible = visible; }

    void                setEditingCursorViewMatrix(const float matrix[]);
    void                registerEditCursor(DCVCEditModeCursor *cursor);
    void                unregisterEditCursor();

    //Called from command
    //this will remove axon terminal from the list and the object itself
    bool                removeAxonTerminal(DCAxonTerminal *terminal);

};

#endif // DCAXON_H
