//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Nov-3, 2012.
//
#ifndef DCCELLCODEEDITORPAGEWIDGET_H
#define DCCELLCODEEDITORPAGEWIDGET_H

#include <QWidget>
#include <QSplitter>
#include <QPushButton>

#include "dceditscriptfolder.h"

class DCCell;
class DCCellCode;
class DCCodeEditor;
class DCVCPage;

class DCCellScriptsEditorPageWidget : public QWidget
{
    Q_OBJECT

    DCCell          *d_cell;
    DCCellCode      *d_cellCodeOrg;
    DCCodeEditor    *d_customScriptEditor;
    DCCodeEditor    *d_cellCodeScriptEditor;

    QSplitter       *d_splitter;

    bool                d_modified;
    DCEditScriptFolder  d_customScriptFolder;
    DCEditScriptFolder  d_cellCodeScriptFolder;

    QPushButton         *d_customScriptEditExternalButton;
    QPushButton         *d_cellCodeScriptEditExternalButton;
    bool                d_customScriptExternalMode;
    bool                d_cellCodeScriptExternalMode;

    bool            loadCustomScript(bool forceReload = false);
    bool            loadCellCodeScript(bool forceReload = false);
    bool            loadScripts();
    void            updateModifiedStatus();

public:
    DCCellScriptsEditorPageWidget(DCCell *targetCell, QWidget *parent = 0);
    virtual ~DCCellScriptsEditorPageWidget();

    bool            getIsModified() const;
    bool            getIsCustomScriptModifiedByExternalEditor() const;
    bool            getIsCellCodeModifiedByExternalEditor() const;
    qint64          getCustomScriptLoadedTime() const;
    qint64          getCellCodeScriptLoadedTime() const;
    bool            getIsCustomScriptExternalMode() const { return d_customScriptExternalMode; }
    bool            getIsCellCodeScriptExternalMode() const { return d_cellCodeScriptExternalMode; }

    void            setReadOnly(bool readOnly);
    QSet<DCVCPage*> saveScriptsToFile(bool saveModifiedOnly);
    bool            saveCustomScriptOnlyToFile(bool saveModifiedOnly);
    bool            saveCellCodeScriptOnlyToFile(bool saveModifiedOnly);

    void            focusCustomScript();
    void            focusCellCodeScript();

    void            reloadCustomScript();
    void            reloadCellCodeScript();

signals:
    void editingCellDestroyed(DCCell *cell);
    void cellScriptsModifiedStatusChanged(QWidget *self, bool modified);
    void cellScriptsSaved(QWidget *self);
    void customScriptModifiedByExternalEditor(QWidget *self, qint64 notifiedTime);
    void cellCodeScriptModifiedByExternalEditor(QWidget *self, qint64 notifiedTime);

private slots:
    void assignedCellCodeChanged();
    void cellDestroyed();
    void editorCustomScriptChanged();
    void editorCellCodeScriptChanged();
    void folderCustomScriptChanged();
    void folderCellCodeScriptChanged();
    void folderCustomScriptModifiedStatusChanged(bool modified);
    void folderCellCodeScriptModifiedStatusChanged(bool modified);
    void folderCustomScriptFileModifiedByExternalEditor(qint64 notifiedTime);
    void folderCellCodeScriptFileModifiedByExternalEditor(qint64 notifiedTime);

    void useExternalEditorForCustomScriptPressed();
    void useExternalEditorForCellCodeScriptPressed();
};

#endif // DCCELLCODEEDITORPAGEWIDGET_H
