//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#include "dctoolwindowviewcontrol.h"

DCToolWindowViewControl::DCToolWindowViewControl(DCCreator *creator) :
    DCToolWindowBase(tr("Navigation mode"), creator), d_dcScene(NULL)
{

    //navigation mode
    QGridLayout *gridLayout1 = new QGridLayout;
    gridLayout1->setContentsMargins(0,0,0,0);
    gridLayout1->addWidget(new QLabel(tr("Selected cell")),0,0);
    gridLayout1->addWidget(new QLabel(tr("Other cell")),1,0);
    gridLayout1->addWidget(new QLabel(tr("Selected page")),4,0);
    gridLayout1->addWidget(new QLabel(tr("Above")),5,0);
    gridLayout1->addWidget(new QLabel(tr("Below")),6,0);

    d_NSelectedCellMovableChkBtn = new QCheckBox("movable");
    gridLayout1->addWidget(d_NSelectedCellMovableChkBtn, 0,1);
    connect(d_NSelectedCellMovableChkBtn, SIGNAL(stateChanged(int)), this, SLOT(uiNSelectedCellMovableStateChanged(int)));

    d_NOtherCellSelectableChkBtn = new QCheckBox("selectable");
    gridLayout1->addWidget(d_NOtherCellSelectableChkBtn, 1,1);
    connect(d_NOtherCellSelectableChkBtn, SIGNAL(stateChanged(int)), this, SLOT(uiNOtherCellSelectableStateChanged(int)));

    d_NOtherCellVisibleChkBtn = new QCheckBox("visible");
    gridLayout1->addWidget(d_NOtherCellVisibleChkBtn, 2,1);
    connect(d_NOtherCellVisibleChkBtn, SIGNAL(stateChanged(int)), this, SLOT(uiNOtherCellVisibleStateChanged(int)));

    d_NOtherCellRenderFullRadioBtn = new QRadioButton("render full");
    d_NOtherCellRenderFullRadioBtn->setAutoExclusive(false);
    gridLayout1->addWidget(d_NOtherCellRenderFullRadioBtn, 3,1);
    connect(d_NOtherCellRenderFullRadioBtn, SIGNAL(clicked()), this, SLOT(uiNOtherCellRenderFullSelected()));

    d_NOtherCellRenderWireRadioBtn = new QRadioButton("render wire");
    d_NOtherCellRenderWireRadioBtn->setAutoExclusive(false);
    gridLayout1->addWidget(d_NOtherCellRenderWireRadioBtn, 3,2);
    connect(d_NOtherCellRenderWireRadioBtn, SIGNAL(clicked()), this, SLOT(uiNOtherCellRenderWireSelected()));

    d_NSelectedPageSlider = new QSlider(Qt::Horizontal);
    gridLayout1->addWidget(d_NSelectedPageSlider, 4,1,1,2);
    d_NSelectedPageSlider->setMaximum(100);
    d_NSelectedPageSlider->setMinimum(0);
    connect(d_NSelectedPageSlider, SIGNAL(valueChanged(int)), this, SLOT(uiNSelectedPageAlphaChanged(int)));

    d_NAbovePageSlider = new QSlider(Qt::Horizontal);
    gridLayout1->addWidget(d_NAbovePageSlider, 5,1,1,2);
    d_NAbovePageSlider->setMaximum(100);
    d_NAbovePageSlider->setMinimum(0);
    connect(d_NAbovePageSlider, SIGNAL(valueChanged(int)), this, SLOT(uiNAbovePageAlphaChanged(int)));

    d_NBelowPageSlider = new QSlider(Qt::Horizontal);
    gridLayout1->addWidget(d_NBelowPageSlider, 6,1,1,2);
    d_NBelowPageSlider->setMaximum(100);
    d_NBelowPageSlider->setMinimum(0);
    connect(d_NBelowPageSlider, SIGNAL(valueChanged(int)), this, SLOT(uiNBelowPageAlphaChanged(int)));

    // page edit mode
    QGridLayout *gridLayout2 = new QGridLayout;
    gridLayout2->setContentsMargins(0,0,0,0);
    gridLayout2->addWidget(new QLabel(tr("Other -same page")),0,0);
    gridLayout2->addWidget(new QLabel(tr("Linked -other page")),1,0);
    gridLayout2->addWidget(new QLabel(tr("Other -other page")),3,0);
    gridLayout2->addWidget(new QLabel(tr("Selecated page")),5,0);
    gridLayout2->addWidget(new QLabel(""),6,0);

    d_POtherSamePageRenderFullRadioBtn = new QRadioButton("render full");
    d_POtherSamePageRenderFullRadioBtn->setAutoExclusive(false);
    gridLayout2->addWidget(d_POtherSamePageRenderFullRadioBtn, 0,1);
    connect(d_POtherSamePageRenderFullRadioBtn, SIGNAL(clicked()), this, SLOT(uiPOtherSamePageFullSelected()));

    d_POtherSamePageRenderWireRadioBtn = new QRadioButton("render wire");
    d_POtherSamePageRenderWireRadioBtn->setAutoExclusive(false);
    gridLayout2->addWidget(d_POtherSamePageRenderWireRadioBtn, 0,2);
    connect(d_POtherSamePageRenderWireRadioBtn, SIGNAL(clicked()), this, SLOT(uiPOtherSamePageWireSelected()));

    d_PLinkedOtherPageVisibleChkBtn = new QCheckBox("visible");
    gridLayout2->addWidget(d_PLinkedOtherPageVisibleChkBtn, 1,1);
    connect(d_PLinkedOtherPageVisibleChkBtn, SIGNAL(stateChanged(int)), this, SLOT(uiPLinkedOtherPageVisibleStateChanged(int)));

    d_PLinkedOtherPageRenderFullRadioBtn = new QRadioButton("render full");
    d_PLinkedOtherPageRenderFullRadioBtn->setAutoExclusive(false);
    gridLayout2->addWidget(d_PLinkedOtherPageRenderFullRadioBtn, 2,1);
    connect(d_PLinkedOtherPageRenderFullRadioBtn, SIGNAL(clicked()), this, SLOT(uiPLinkedOtherPageFullSelected()));

    d_PLinkedOtherPageRenderWireRadioBtn = new QRadioButton("render wire");
    d_PLinkedOtherPageRenderWireRadioBtn->setAutoExclusive(false);
    gridLayout2->addWidget(d_PLinkedOtherPageRenderWireRadioBtn, 2,2);
    connect(d_PLinkedOtherPageRenderWireRadioBtn, SIGNAL(clicked()), this, SLOT(uiPLinkedOtherPageWireSelected()));

    d_POtherOtherPageVisibleChkBtn = new QCheckBox("visible");
    gridLayout2->addWidget(d_POtherOtherPageVisibleChkBtn, 3,1);
    connect(d_POtherOtherPageVisibleChkBtn, SIGNAL(stateChanged(int)), this, SLOT(uiPOtherOtherPageVisibleStateChanged(int)));

    d_POtherOtherPageRenderFullRadioBtn = new QRadioButton("render full");
    d_POtherOtherPageRenderFullRadioBtn->setAutoExclusive(false);
    gridLayout2->addWidget(d_POtherOtherPageRenderFullRadioBtn, 4,1);
    connect(d_POtherOtherPageRenderFullRadioBtn, SIGNAL(clicked()), this, SLOT(uiPOtherOtherPageFullSelected()));

    d_POtherOtherPageRenderWireRadioBtn = new QRadioButton("render wire");
    d_POtherOtherPageRenderWireRadioBtn->setAutoExclusive(false);
    gridLayout2->addWidget(d_POtherOtherPageRenderWireRadioBtn, 4,2);
    connect(d_POtherOtherPageRenderWireRadioBtn, SIGNAL(clicked()), this, SLOT(uiPOtherOtherPageWireSelected()));

    d_PSelectedPageSlider = new QSlider(Qt::Horizontal);
    gridLayout2->addWidget(d_PSelectedPageSlider, 5,1,1,2);
    d_PSelectedPageSlider->setMaximum(100);
    d_PSelectedPageSlider->setMinimum(0);
    connect(d_PSelectedPageSlider, SIGNAL(valueChanged(int)), this, SLOT(uiPSelectedPageAlphaChanged(int)));

    //
    QWidget *w1 = new QWidget;
    QWidget *w2 = new QWidget;
    w1->setLayout(gridLayout1);
    w2->setLayout(gridLayout2);
    d_stackedLayout = new QStackedLayout;
    d_stackedLayout->setContentsMargins(0,0,0,0);
    contentLayout()->addLayout(d_stackedLayout);
    d_stackedLayout->addWidget(w1);
    d_stackedLayout->addWidget(w2);
    d_stackedLayout->setCurrentIndex(0);

}


void DCToolWindowViewControl::setDCScene(DCScene *dcScene)
{
    d_dcScene = dcScene;
    if (dcScene)
    {
        d_NSelectedCellMovableChkBtn->setChecked(dcScene->getNavModeSelectedCellMovable());
        d_NOtherCellSelectableChkBtn->setChecked(dcScene->getNavModeOtherCellSelectable());
        d_NOtherCellVisibleChkBtn->setChecked(dcScene->getNavModeOtherCellVisible());
        d_NOtherCellRenderFullRadioBtn->setChecked(dcScene->getNavModeOtherCellRenderFull());
        d_NOtherCellRenderWireRadioBtn->setChecked(!dcScene->getNavModeOtherCellRenderFull());
        d_NSelectedPageSlider->setValue(dcScene->getNavModeSelectedPageAlpha() * 100);
        d_NAbovePageSlider->setValue(dcScene->getNavModeAboveAlpha() * 100);
        d_NBelowPageSlider->setValue(dcScene->getNavModeBelowAlpha() * 100);

        d_POtherSamePageRenderFullRadioBtn->setChecked(dcScene->getPageModeOtherSamePageRenderFull());
        d_POtherSamePageRenderWireRadioBtn->setChecked(!dcScene->getPageModeOtherSamePageRenderFull());
        d_PLinkedOtherPageVisibleChkBtn->setChecked(dcScene->getPageModeLinkedOtherPageVisible());
        d_PLinkedOtherPageRenderFullRadioBtn->setChecked(dcScene->getPageModeLinkedOtherPageRenderFull());
        d_PLinkedOtherPageRenderFullRadioBtn->setEnabled(dcScene->getPageModeLinkedOtherPageVisible());
        d_PLinkedOtherPageRenderWireRadioBtn->setChecked(!dcScene->getPageModeLinkedOtherPageRenderFull());
        d_PLinkedOtherPageRenderWireRadioBtn->setEnabled(dcScene->getPageModeLinkedOtherPageVisible());
        d_POtherOtherPageVisibleChkBtn->setChecked(dcScene->getPageModeOtherOtherPageVisible());
        d_POtherOtherPageRenderFullRadioBtn->setChecked(dcScene->getPageModeOtherOtherPageRenderFull());
        d_POtherOtherPageRenderFullRadioBtn->setEnabled(dcScene->getPageModeOtherOtherPageVisible());
        d_POtherOtherPageRenderWireRadioBtn->setChecked(!dcScene->getPageModeOtherOtherPageRenderFull());
        d_POtherOtherPageRenderWireRadioBtn->setEnabled(dcScene->getPageModeOtherOtherPageVisible());
        d_PSelectedPageSlider->setValue(dcScene->getPageModeSelectedAlpha() * 100);

        changeMode(this);
    }
}


void DCToolWindowViewControl::changeMode(const void* requester)
{
    (void)requester;

    switch (d_dcScene->getPersMode())
    {
    case DCScene::DCV_PERSMODE_NAVIGATION:
        d_stackedLayout->setCurrentIndex(0);
        setButtonedWindowTitle("Navigation perspective");
        break;

    case DCScene::DCV_PERSMODE_PAGEEDIT:
        d_stackedLayout->setCurrentIndex(1);
        setButtonedWindowTitle("Page perspective");
        break;
    }
}

void DCToolWindowViewControl::uiNSelectedCellMovableStateChanged(int state)
{
    if (d_dcScene)
        d_dcScene->setNavModeSelectedCellMovable(this, state == Qt::Checked);
}

void DCToolWindowViewControl::uiNOtherCellSelectableStateChanged(int state)
{
    if (d_dcScene)
        d_dcScene->setNavModeOtherCellSelectable(this, state == Qt::Checked);
}

void DCToolWindowViewControl::uiNOtherCellVisibleStateChanged(int state)
{
    d_NOtherCellRenderFullRadioBtn->setEnabled(state == Qt::Checked);
    d_NOtherCellRenderWireRadioBtn->setEnabled(state == Qt::Checked);
    if (d_dcScene)
        d_dcScene->setNavModeOtherCellVisible(this, state == Qt::Checked);
}

void DCToolWindowViewControl::uiNOtherCellRenderFullSelected()
{
    d_NOtherCellRenderFullRadioBtn->setChecked(true);
    d_NOtherCellRenderWireRadioBtn->setChecked(false);
    if (d_dcScene)
        d_dcScene->setNavModeOtherCellRenderFull(this, true);
}

void DCToolWindowViewControl::uiNOtherCellRenderWireSelected()
{
    d_NOtherCellRenderFullRadioBtn->setChecked(false);
    d_NOtherCellRenderWireRadioBtn->setChecked(true);
    if (d_dcScene)
        d_dcScene->setNavModeOtherCellRenderFull(this, false);
}

void DCToolWindowViewControl::uiNSelectedPageAlphaChanged(int alpha)
{
    if (d_dcScene)
        d_dcScene->setNavModeSelectedPageAlpha(this, alpha / 100.0);
}

void DCToolWindowViewControl::uiNAbovePageAlphaChanged(int alpha)
{
    if (d_dcScene)
        d_dcScene->setNavModeAboveAlpha(this, alpha / 100.0);
}

void DCToolWindowViewControl::uiNBelowPageAlphaChanged(int alpha)
{
    if (d_dcScene)
        d_dcScene->setNavModeBelowAlpha(this, alpha / 100.0);
}


//page edit mode
void DCToolWindowViewControl::uiPOtherSamePageFullSelected()
{
    d_POtherSamePageRenderFullRadioBtn->setChecked(true);
    d_POtherSamePageRenderWireRadioBtn->setChecked(false);
    if (d_dcScene)
        d_dcScene->setPageModeOtherSamePageRenderFull(this, true);
}

void DCToolWindowViewControl::uiPOtherSamePageWireSelected()
{
    d_POtherSamePageRenderFullRadioBtn->setChecked(false);
    d_POtherSamePageRenderWireRadioBtn->setChecked(true);
    if (d_dcScene)
        d_dcScene->setPageModeOtherSamePageRenderFull(this, false);
}

void DCToolWindowViewControl::uiPLinkedOtherPageVisibleStateChanged(int state)
{
    d_PLinkedOtherPageRenderFullRadioBtn->setEnabled( state == Qt::Checked);
    d_PLinkedOtherPageRenderWireRadioBtn->setEnabled( state == Qt::Checked);
    if (d_dcScene)
        d_dcScene->setPageModeLinkedOtherPageVisible(this, state == Qt::Checked);
}

void DCToolWindowViewControl::uiPLinkedOtherPageFullSelected()
{
    d_PLinkedOtherPageRenderFullRadioBtn->setChecked(true);
    d_PLinkedOtherPageRenderWireRadioBtn->setChecked(false);
    if (d_dcScene)
        d_dcScene->setPageModeLinkedOtherPageRenderFull(this, true);
}

void DCToolWindowViewControl::uiPLinkedOtherPageWireSelected()
{
    d_PLinkedOtherPageRenderFullRadioBtn->setChecked(false);
    d_PLinkedOtherPageRenderWireRadioBtn->setChecked(true);
    if (d_dcScene)
        d_dcScene->setPageModeLinkedOtherPageRenderFull(this, false);
}

void DCToolWindowViewControl::uiPOtherOtherPageVisibleStateChanged(int state)
{
    d_POtherOtherPageRenderFullRadioBtn->setEnabled( state == Qt::Checked);
    d_POtherOtherPageRenderWireRadioBtn->setEnabled( state == Qt::Checked);
    if (d_dcScene)
        d_dcScene->setPageModeOtherOtherPageVisible(this, state == Qt::Checked);
}

void DCToolWindowViewControl::uiPOtherOtherPageFullSelected()
{
    d_POtherOtherPageRenderFullRadioBtn->setChecked(true);
    d_POtherOtherPageRenderWireRadioBtn->setChecked(false);
    if (d_dcScene)
        d_dcScene->setPageModeOtherOtherPageRenderFull(this, true);
}

void DCToolWindowViewControl::uiPOtherOtherPageWireSelected()
{
    d_POtherOtherPageRenderFullRadioBtn->setChecked(false);
    d_POtherOtherPageRenderWireRadioBtn->setChecked(true);
    if (d_dcScene)
        d_dcScene->setPageModeOtherOtherPageRenderFull(this, false);
}

void DCToolWindowViewControl::uiPSelectedPageAlphaChanged(int alpha)
{
    if (d_dcScene)
        d_dcScene->setPageModeSelectedAlpha(this, alpha / 100.0);
}

