//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#include "dctoolwindowterminalfromreceptoreditor.h"

#include "dceditablelabel.h"
#include "dccell.h"

#include <QGroupBox>
#include <QGridLayout>


DCToolWindowTerminalFromReceptor::DCToolWindowTerminalFromReceptor(DCCreator *creator) :
    DCToolWindowBase(tr("Add axon terminal"), creator), d_receptorCell(NULL), d_receptor(NULL), d_axonCell(NULL), d_axonPagePathString("")
{
    QGroupBox *receptorBox = new QGroupBox("Receptor side");
    QGridLayout *receptorLayout = new QGridLayout;
    receptorLayout->setSpacing(6);
    d_textReceptorCellName = new DCEditableLabel(this, "");
    d_textReceptorCellPath = new DCEditableLabel(this, "");
    d_textReceptorName = new DCEditableLabel(this, "");

    receptorLayout->addWidget(new QLabel(tr("cell")),0,0);
    receptorLayout->addWidget(new QLabel(tr("location")),1,0);
    receptorLayout->addWidget(new QLabel(tr("receptor")),2,0);
    receptorLayout->addWidget(d_textReceptorCellName, 0,1);
    receptorLayout->addWidget(d_textReceptorCellPath, 1,1);
    receptorLayout->addWidget(d_textReceptorName, 2,1);
    receptorBox->setLayout(receptorLayout);

    QGroupBox *axonBox = new QGroupBox("Axon side");
    QGridLayout *axonLayout = new QGridLayout;
    axonLayout->setSpacing(6);
    d_textAxonCellName = new DCEditableLabel(this, "");
    d_textAxonCellPath = new DCEditableLabel(this, "");
    axonLayout->addWidget(new QLabel(tr("cell")),0,0);
    axonLayout->addWidget(new QLabel(tr("location")),1,0);
    axonLayout->addWidget(d_textAxonCellName, 0,1);
    axonLayout->addWidget(d_textAxonCellPath, 1,1);
    axonBox->setLayout(axonLayout);

    contentLayout()->addWidget(receptorBox);
    contentLayout()->addWidget(axonBox);
}

DCToolWindowTerminalFromReceptor::~DCToolWindowTerminalFromReceptor()
{

}



void DCToolWindowTerminalFromReceptor::updateData(DCCell *receptorCell, DCReceptor *receptor, const QString &axonPagePath, DCCell *axonCell)
{
    if (d_receptorCell != receptorCell || d_receptor != receptor)
    {
        d_receptorCell = receptorCell;
        d_receptor = receptor;
        d_receptorName = QString::fromStdString(receptorCell->getReceptorName(receptor));
    }

    d_axonCell = axonCell;
    d_axonPagePathString = axonPagePath;

    if (receptorCell)
    {
        d_textReceptorCellName->setText(QString::fromStdString(receptorCell->getName()));
        d_textReceptorCellPath->setText(QString::fromStdString(receptorCell->getLocation()));
        d_textReceptorName->setText(d_receptorName);
    }
    else
    {
        d_textReceptorCellName->setText("");
        d_textReceptorCellPath->setText("");
    }

    d_textAxonCellPath->setText(axonPagePath);

    if (axonCell)
    {
        d_textAxonCellName->setText(QString::fromStdString(axonCell->getName()));
    }
    else
    {
        d_textAxonCellName->setText("");
    }
}

void DCToolWindowTerminalFromReceptor::resetData()
{
    d_receptorCell = NULL;
    d_receptor = NULL;
}
