//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCEDITABLETREEVIEW_H
#define DCEDITABLETREEVIEW_H

#include <QtGui>
#include <QTreeView>

class DCEditableTreeView : public QTreeView
{
    Q_OBJECT
private:
    int     d_maximumVisibleRow;
    int     calculateHeight(const QModelIndex &parent = QModelIndex()) const;

public:
    explicit DCEditableTreeView(QWidget *parent = 0);
    virtual ~DCEditableTreeView();

    
protected:
    virtual QSize	sizeHint () const;

signals:
    void    vscrollbarShown();
    void    vscrollbarHidden();

public slots:
    void    slotVScrollbarShown();
    void    slotVScrollbarHidden();
};

class ScrollBar : public QScrollBar
{
    Q_OBJECT

public:
    ScrollBar() : QScrollBar() {}
    virtual ~ScrollBar() {}

protected:
    virtual void showEvent(QShowEvent *event)
    {
        (void)event;
        emit shown();
    }

    virtual void hideEvent(QHideEvent *event)
    {
        (void)event;
        emit hidden();
    }

signals:
    void    shown();
    void    hidden();
};

#endif // DCEDITABLETREEVIEW_H
