/*
 *  cuberenderer.h
 *
 *  CubeRenderer class - rendering rounded cube
 *
 *  Copyright (C) 2010  Takuji Kawata
 */
//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//

#ifndef DCCUBERENDERER_H
#define DCCUBERENDERER_H

#include <QGLWidget>
#if !defined(Q_WS_MAC)
    #include <GL/gl.h>
#else
    #include <gl.h>
#endif
#include <string>

class DCCubeRenderer
{
public:
    DCCubeRenderer(float size, float height, float radius, int r_step, bool cache = true);
    virtual ~DCCubeRenderer();

    void draw();
    void setEdgeColor(GLfloat r, GLfloat g, GLfloat b);
    void setFaceColor(GLfloat r, GLfloat g, GLfloat b);
    void setTextLabel(const QString &text1, const QString &text2, const QString &text3 = "");
    void setSize(float size);
    void setHeight(float height);

private:
    bool buildShape();
    void buildTextures();
    void deleteTextures();

    void renderSideFaces();
    void renderTopAndBottomFaces();
    void renderEdges();
    void renderJoints();

    float m_size;
    float m_height;
    float m_radius;
    float m_step;
    bool  m_cache;

    bool    m_shapeValid;
    GLuint  m_shapeId;
    bool    m_shapeUpdated;
    QGLWidget *m_widget;

    GLuint  m_textures[6];
    GLfloat m_edgeColor[4];
    GLfloat m_faceColor[4];

    QString m_text1;
    QString m_text2;
    QString m_text3;

};

#endif // DCCUBERENDERER_H
