//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCVPAGECOMPONENT_H
#define DCVPAGECOMPONENT_H

#include "dcvcomponent.h"

#include "dcvcpage.h"

class DCVPageComponent : public DCVComponent
{
    friend class DCVCPage;

    DCVCPage    *d_page;
    float       d_pageX;
    float       d_pageY;

    void regiesteredToPage(DCVCPage *page) { d_page = page; }
    void unregisteredFromPage() { d_page = NULL; }

public:
    DCVPageComponent() : d_page(NULL), d_pageX(0), d_pageY(0) {}
    explicit DCVPageComponent(DCVCPage *page) : d_page(page), d_pageX(0), d_pageY(0) {}
    virtual ~DCVPageComponent() {}

    inline DCVCPage* getPageBelonging() const{ return d_page; }

    virtual void  changePageBelonging(DCVCPage *page) = 0;

    virtual float getPageX() const { return d_pageX; }
    virtual float getPageY() const { return d_pageY; }

    virtual void  setPageX(float x) { d_pageX = x; }
    virtual void  setPageY(float y) { d_pageY = y; }

};

#endif // DCVPAGECOMPONENT_H
