//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCVCAXON_H
#define DCVCAXON_H

#include "dcvcomponent.h"

#include <QtOpenGL>

class DCAxon;
class DCCell;
class DCCubeRenderer;

class DCVCAxon : public DCVComponent
{
    DCAxon                  *d_owner;
    bool                    d_shouldUpdateShape;

public:
    DCVCAxon(DCAxon *owner);
    virtual ~DCVCAxon();

    virtual DCVCPage *  getPageBelonging() const;
    virtual bool        isResizingArea(float x, float y, float z) const { Q_UNUSED(x); Q_UNUSED(y); Q_UNUSED(z); return false; }

    virtual DCCell *    getOwnerCell() const;

    virtual void    prepareChildrenForDraw(bool isAnimationInterval);
    virtual void    drawChildren(bool isAnimationInterval);
    virtual void    drawChildrenForSelection(QList<DCVComponent*> *itemList);
    virtual void    translate();
    virtual void    setSelected(bool selected, bool updateChildren = false);
    virtual void    setVisible(DCVVisibility visibleSelf, DCVVisibility visibleChildren);
    virtual void    renderOwnShape(bool isAnimationInterval, bool renderAsWireframe);

    virtual bool    startDrag(float x, float y, float z, bool isResizingDrag);
    virtual bool    dragging(float x, float y, float z, bool isResizingDrag);
    virtual bool    endDrag(float x, float y, float z, bool isResizingDrag);
    virtual void    updateShape();

    virtual void    saveAttributesToXML(QDomDocument *document, QDomElement* element) const;
    virtual void    loadAttributesFromXML(QDomElement element);
};

#endif // DCVCAXON_H
