//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCQTITEMMODEL_H
#define DCQTITEMMODEL_H

#include <QAbstractItemModel>
#include <QVector>
#include <QStringList>

class DCQtItemModelItem
{
public:
    DCQtItemModelItem(const QVector<QVariant> &data, DCQtItemModelItem *parent = 0);
    DCQtItemModelItem(const QStringList &headers, DCQtItemModelItem *parent = 0);
    virtual ~DCQtItemModelItem();

    DCQtItemModelItem *child(int number);
    int childCount() const;
    int columnCount() const;
    virtual QVariant data(int column) const;
    virtual bool insertChildren(int position, int count, int columns);
    virtual bool insertColumns(int position, int columns);
    virtual DCQtItemModelItem *parent();
    virtual bool removeChildren(int position, int count);
    virtual bool removeColumns(int position, int columns);
    int childNumber() const;
    virtual bool setData(int column, const QVariant &value);

protected:
    QList<DCQtItemModelItem*> mChildItems;
    QVector<QVariant> mItemData;
    DCQtItemModelItem *mParentItem;
};

class DCQtItemModel : public QAbstractItemModel
{
    Q_OBJECT
public:
    DCQtItemModel(const QStringList &headers, DCQtItemModelItem *rootItem = 0, QObject *parent = 0);
    virtual ~DCQtItemModel();

    QVariant data(const QModelIndex &index, int role) const;
    QVariant headerData(int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const;

    QModelIndex index(int row, int column, const QModelIndex &parent = QModelIndex()) const;
    QModelIndex parent(const QModelIndex &index) const;

    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    int columnCount(const QModelIndex &parent = QModelIndex()) const;

    virtual Qt::ItemFlags flags(const QModelIndex &index) const;
    virtual bool setData(const QModelIndex &index, const QVariant &value, int role = Qt::EditRole);
    bool setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role = Qt::EditRole);

    bool insertColumns(int position, int columns, const QModelIndex &parent = QModelIndex());
    bool removeColumns(int position, int columns, const QModelIndex &parent = QModelIndex());
    bool insertRows(int position, int rows, const QModelIndex &parent = QModelIndex());
    bool removeRows(int position, int rows, const QModelIndex &parent = QModelIndex());
    bool removeAllItems();

    //
    bool insertStringList(const QStringList &stringList, const QModelIndex &parent = QModelIndex());
    bool insertString(const QString &string, const QModelIndex &parent = QModelIndex());
    void setReadOnly(int column, bool isReadOnly);

protected:
    DCQtItemModelItem *getItem(const QModelIndex &index) const;

    DCQtItemModelItem *mRootItem;
    QVector<bool> mReadOnlyAttrib;
signals:
    
public slots:
    
};

#endif // DCQTITEMMODEL_H
