//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#include "dccommandutil.h"

#include <QtGui>

#include "command/dceditcommands.h"
#include "command/dccommandevent.h"
#include "dccreator.h"

static void postEvent(QObject *target, DCCommand *command)
{
    QEvent *event = new DCCommandEvent(command);
    QApplication::instance()->postEvent(target, event);
}


//static
void DCCommandUtil::postStartAddAxonTerminalCommandFromAxon(const void *requester, DCCreator *creator, DCCell *ownerCell)
{
    postEvent(creator, new DCStartAddAxonTerminalCommandFromAxon(requester, creator, ownerCell));
}

//static
void DCCommandUtil::postStartAddAxonTerminalCommandFromReceptor(const void *requester, DCCreator *creator, DCCell *ownerCell, const QString &receptorName)
{
    postEvent(creator, new DCStartAddAxonTerminalCommandFromReceptor(requester, creator, ownerCell, receptorName));
}

//static
void DCCommandUtil::postCommitAddAxonTerminalCommand(const void *requester, DCCreator *creator, DCAxon *axon, DCCell *receptorCell, const QString &receptorName)
{
    postEvent(creator, new DCCommitAddAxonTerminalCommand(requester, creator, axon, receptorCell, receptorName));
}

//static
void DCCommandUtil::postCommitAddAxonTerminalCommand(const void *requester, DCCreator *creator, DCCell *axonCell, DCReceptor *receptor)
{
    postEvent(creator, new DCCommitAddAxonTerminalCommand(requester, creator, axonCell, receptor));
}

//static
void DCCommandUtil::postRemoveAxonTerminalCommand(const void *requester, DCCreator *creator, DCCell *axonCell, DCAxonTerminal *axonTerminal)
{
    postEvent(creator, new DCRemoveAxonTerminalCommand(requester, creator, axonCell, axonTerminal));
}

//static
void DCCommandUtil::postRemoveAxonTerminalCommand(const void *requester, DCCreator *creator, DCCell *receptorCell, const QString &receptorName)
{
    postEvent(creator, new DCRemoveAxonTerminalCommand(requester, creator, receptorCell, receptorName));
}

//static
void DCCommandUtil::postUndoRequestCommand(const void *requester, DCCreator *creator)
{
    (void)requester;

    QEvent *event = new DCUndoEvent();
    QApplication::instance()->postEvent(creator, event);
}

//static
void DCCommandUtil::postAssignCellCodeClassToCellCommand(const void *requester, DCCreator *creator, DCCell *cell, DCCellCode *cellCode)
{
    postEvent(creator, new DCAssignCellCodeClassToCellCommand(requester, creator, cell, cellCode));
}

//static
void DCCommandUtil::postUnassignCellCodeClassFromCellCommand(const void *requester, DCCreator *creator, DCCell *cell)
{
    postEvent(creator, new DCUnassignCellCodeClassFromCellCommand(requester, creator, cell));
}

//static
void DCCommandUtil::postAddCellCodeClassCommand(const void *requester, DCCreator *creator, DCContainer *container, const QString &name, const QString &type)
{
    postEvent(creator, new DCAddCellCodeClassCommand(requester, creator, container, name, type));
}

//static
void DCCommandUtil::postChangeCellCodeClassTypeCommand(const void *requester, DCCreator *creator, DCCellCode *cellCode, const QString &newType)
{
    postEvent(creator, new DCChangeCellCodeClassTypeCommand(requester, creator, cellCode, newType));
}

//static
void DCCommandUtil::postAddCellCommand(const void *requester, DCCreator *creator, DCContainer *container, const QString &containerBasedPath, const QString &name, const QString &type, float pageX, float pageY)
{
    postEvent(creator, new DCAddCellCommand(requester, creator, container, containerBasedPath, name, type, pageX, pageY));
}

//static
void DCCommandUtil::postChangeCellTypeCommand(const void *requester, DCCreator *creator, DCCell *cell, const QString &newType)
{
    postEvent(creator, new DCChangeCellTypeCommand(requester, creator, cell, newType));
}

//static
void DCCommandUtil::postRenameCellCommand(const void *requester, DCCreator *creator, DCCell *cell, const QString &newContainerBasedPath, const QString &newName)
{
    postEvent(creator, new DCRenameCellCommand(requester, creator, cell, newContainerBasedPath, newName));
}

//static
void DCCommandUtil::postRemoveCellCommand(const void *requester, DCCreator *creator, DCContainer *container, DCCell* cell)
{
    postEvent(creator, new DCRemoveCellCommand(requester, creator, container, cell));
}

//static
void DCCommandUtil::postRemoveCellCodeCommand(const void *requester, DCCreator *creator, DCContainer *container, DCCellCode* cellCode)
{
    postEvent(creator, new DCRemoveCellCodeClassCommand(requester, creator, container, cellCode));
}

//static
void DCCommandUtil::postRemoveCellsCommand(const void *requester, DCCreator *creator, DCContainer *container, const QList<DCCell*> &cells)
{
    postEvent(creator, new DCRemoveCellCommand(requester, creator, container, cells));
}

//static
void DCCommandUtil::postAddPageCommand(const void *requester, DCCreator *creator, const QString& containerBasedPath)
{
    postEvent(creator, new DCAddPageCommand(requester, creator, containerBasedPath));
}

//static
void DCCommandUtil::postMovePageCommand(const void *requester, DCCreator *creator, const QString &oldContainerBasedPath, const QString &newContainerBasedPath)
{
    postEvent(creator, new DCMovePageCommand(requester, creator, oldContainerBasedPath, newContainerBasedPath));
}

//static
void DCCommandUtil::postRemovePageCommand(const void *requester, DCCreator *creator, DCVCPage *page)
{
    postEvent(creator, new DCRemovePageCommand(requester, creator, page));
}

//static
void DCCommandUtil::postAddDirectoryCommand(const void *requester, DCCreator *creator, const QString &sysFilePath)
{
    postEvent(creator, new DCAddDirectoryCommand(requester, creator, sysFilePath));
}

//static
void DCCommandUtil::postRenameDirectoryCommand(const void *requester, DCCreator *creator, const QString &sysOldFilePath, const QString &sysNewFilePath)
{
    postEvent(creator, new DCRenameDirectoryCommand(requester, creator, sysOldFilePath, sysNewFilePath));
}

//static
void DCCommandUtil::postRemoveDirectoryCommand(const void *requester, DCCreator *creator, const QString &sysFilePath)
{
    postEvent(creator, new DCRemoveDirectoryCommand(requester, creator, sysFilePath));
}

//static
void DCCommandUtil::postRenameReceptorNameCommand(const void *requester, DCCreator *creator, DCCell *cell, const QString &oldName, const QString &newName)
{
    postEvent(creator, new DCRenameReceptorNameCommand(requester, creator, cell, oldName, newName));
}

//static
DCCommand* DCCommandUtil::createRenameReceptorNameCommand(const void *requester, DCCreator *creator, DCCell *cell, const QString &oldName, const QString &newName)
{
    return new DCRenameReceptorNameCommand(requester, creator, cell, oldName, newName);
}

