//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Oct-26, 2012.
//
#ifndef DCPROPERTYEDITOR_H
#define DCPROPERTYEDITOR_H

#include <QDialog>
#include <QLineEdit>
#include <QCheckBox>
#include <QPushButton>
#include <QComboBox>
#include <QDoubleSpinBox>

class DCPropertyEditor : public QDialog
{
    Q_OBJECT

    QDoubleSpinBox  *d_spinBoxTickInterval;
    QLineEdit       *d_textFieldUIPath;
    QCheckBox       *d_checkBoxHttpServer;
    QCheckBox       *d_checkBoxSerialServer;
    QComboBox       *d_comboBoxSerialSpeed;

    bool            d_isEditing;
    bool            d_isInInitialization;
    QString         d_editingFile;
    QPushButton     *d_saveButton;
    QPushButton     *d_closeButton;

    double          d_originalTickInterval;
    QString         d_originalUIPath;
    bool            d_originalHTTPServer;
    bool            d_originalSerialServer;
    QString         d_originalSerialSpeed;

    bool            getIsModified() const;
    bool            maybeSave();
    void            updateOriginalData();

public:
    explicit DCPropertyEditor(QWidget *parent = 0);
    virtual ~DCPropertyEditor();

    static DCPropertyEditor* getEditor();
    static void destroyEditor();

    virtual void closeEvent(QCloseEvent *event);

    bool startEditing(const QString& sysFilePath);

signals:
        
private slots:
    bool saveChange();
    void propertyChanged();
};

#endif // DCPROPERTYEDITOR_H
