//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 1/2/2012.
//

#include "TKConsole.h"
#include "TKLog.h"

#include <stdarg.h>

TKConsole *TKLog::msConsole = 0;

void TKLog::printf(MessageType type, const char* fmt,...)
{
    if (TKLog::msConsole)
    {
        va_list ap;
        va_start(ap, fmt);
        msConsole->vprintf(type, fmt, ap);
        va_end(ap);        
    }
}

void TKLog::debugPrintf(const char* fmt,...)
{
    if (TKLog::msConsole)
    {
        va_list ap;
        va_start(ap, fmt);
        msConsole->vDebugPrintf(fmt, ap);
        va_end(ap);        
    }
}

void TKLog::setDestination(TKConsole *console) 
{
    TKLog::msConsole = console;
}
    
