//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 3/24/2012.
//
#include "DNStorage.h"

#include "DNStorageImpl.h"

DNStorageXYZVRecords::DNStorageXYZVRecords(int _length) : length(_length), data(0)
{
    data = new DNStorageXYZVData[length];
}

DNStorageXYZVRecords::~DNStorageXYZVRecords()
{
    if (data)
    {
        delete[] data;
        data = 0;
    }
}

DNStorage::DNStorage(const char *storagePath)
{
    impl = DNStorageImpl::create(storagePath);
}

DNStorage::~DNStorage()
{
    if (impl)
    {
        impl->flush();
        delete impl;
        impl = 0;
    }
}

bool  DNStorage::setValue(const char *path, const char *key, float value)
{
    bool r = 0;
    if (impl)
    {
        r = impl->setValue(path,key,value);
    }
    return r;
}

int DNStorage::getCount(const char *path, const char *key)
{
    int r = 0;
    if (impl)
    {
        r = impl->getCount(path,key);
    }
    return r;
}

float  DNStorage::getValue(const char *path, const char *key)
{
    float r = 0;
    if (impl)
    {
        r = impl->getValue(path,key);
    }
    return r;
}

int  DNStorage::countXYZVData(const char *path, const char *key)
{
    int r = 0;
    if (impl)
    {
        r = impl->countXYZVData(path,key);
    }
    return r;
}

bool DNStorage::insertXYZVData(const char *path, const char *key, int index, float x, float y, float z, float v)
{
    bool r = false;
    if (impl)
    {
        r = impl->insertXYZVData(path,key,index,x,y,z,v);
    }
    return r;
}

DNStorageXYZVRecords* DNStorage::queryXYZVData(const char *path, const char *key)
{
    DNStorageXYZVRecords *r = 0;
    if (impl)
    {
        r = impl->queryXYZVData(path,key);
    }
    return r;
}

bool DNStorage::deleteXYZVData(const char *path, const char *key)
{
    bool r = false;
    if (impl)
    {
        r = impl->deleteXYZVData(path,key);
    }
    return r;
}

bool DNStorage::flush()
{
    bool r = false;
    if (impl)
        r = impl->flush();

    return r;
}

bool DNStorage::isValid()
{
    bool r = false;
    if (impl)
        r = impl->isValid();

    return r;
}

bool DNStorage::startTransaction()
{
    bool r = false;
    if (impl)
        r = impl->startTransaction();

    return r;
}

bool DNStorage::commitTransaction()
{
    bool r = false;
    if (impl)
        r = impl->commitTransaction();

    return r;
}

bool DNStorage::rollbackTransaction()
{
    bool r = false;
    if (impl)
        r = impl->rollbackTransaction();

    return r;
}

