//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCINPUTNEWPAGENAMEDIALOG_H
#define DCINPUTNEWPAGENAMEDIALOG_H

#include <QDialog>
#include <QLineEdit>
#include <QPushButton>

class DCInputNewPageNameDialog : public QDialog
{
    Q_OBJECT

    QString     d_dir;
    QString     d_result;
    QLineEdit   *d_inputField;
    QPushButton *d_okButton;
    QPushButton *d_cancelButton;

public:
    DCInputNewPageNameDialog(const QString& sysDir, const QString& windowTitle, const QString& fileName = "", QWidget *parent = 0);
    virtual ~DCInputNewPageNameDialog() {}

    QString getName() const { return d_result + ".xhtml"; }

signals:
    
private slots:
    void okButtonClicked();
    void cancelButtonClicked();
    void inputChanged();
};

#endif // DCINPUTNEWPAGENAMEDIALOG_H
