//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Oct-28, 2012.
//
#ifndef DCINPUTNEWCONTENTDIRDIALOG_H
#define DCINPUTNEWCONTENTDIRDIALOG_H

#include <QDialog>
#include <QLineEdit>
#include <QPushButton>
#include <QLabel>

class DCInputNewContentDirDialog : public QDialog
{
    Q_OBJECT

    QPushButton *d_okButton;
    QPushButton *d_cancelButton;
    QLineEdit   *d_name;
    QLineEdit   *d_path;
    QPushButton *d_chooseDir;
    QLabel      *d_message;

    QString     d_contentPath;
    bool        d_ok;

public:
    DCInputNewContentDirDialog(const QString& dir, QWidget *parent = 0);
    virtual ~DCInputNewContentDirDialog();

    QString getResult() const;

signals:
    
private slots:
    void chooseDirectory();
    void checkInput();
    void okClicked();
};

#endif // DCINPUTNEWCONTENTDIRDIALOG_H
