//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#include "dcassigncellcodeclassdialog.h"

#include "dccreator.h"
#include "dccontainer.h"
#include "dccellcode.h"
#include "utils/dcqtitemmodel.h"
#include "dcaddcellcodeclassdialog.h"
#include "dcsinglecolumntableview.h"

#include <QTableView>
#include <QVBoxLayout>
#include <QPushButton>
#include <QHeaderView>

DCAssignCellCodeClassDialog::DCAssignCellCodeClassDialog(DCCreator *creator, QWidget *parent) :
    QDialog(parent), d_creator(creator), d_selectedCellCodeClassName("")
{
    setWindowTitle(tr("Assign cell code class"));

    d_container = d_creator->getCurrentContainer();
    d_table = new DCSingleColumnTableView();
    QStringList headers;
    headers << "page # name";
    d_tableModel = new DCQtItemModel(headers);
    d_tableModel->setReadOnly(0,true);

    updateClassList();

    d_table->setModel(d_tableModel);

    d_addNewButton = new QPushButton(tr("Add new"));
    setLayout(new QVBoxLayout);
    d_table->horizontalHeader()->setResizeMode(QHeaderView::Stretch);

    d_okButton = new QPushButton(tr("OK"));
    d_cancelButton = new QPushButton(tr("Cancel"));
    QHBoxLayout *buttonLayout = new QHBoxLayout;
    buttonLayout->addItem(new QSpacerItem(10,10, QSizePolicy::Expanding));
    buttonLayout->addWidget(d_cancelButton);
    buttonLayout->addWidget(d_okButton);
    d_okButton->setEnabled(false);
    d_cancelButton->setAutoDefault(true);
    d_cancelButton->setDefault(true);

    layout()->addWidget(d_table);
    layout()->addWidget(d_addNewButton);
    ((QVBoxLayout*)layout())->addLayout(buttonLayout);

    connect(d_okButton, SIGNAL(clicked()), this, SLOT(okButtonClicked()));
    connect(d_cancelButton, SIGNAL(clicked()), this, SLOT(cancelButtonClicked()));
    connect(d_addNewButton, SIGNAL(clicked()), this, SLOT(addNewClicked()));
    connect(d_table,SIGNAL(selectionChangedSignal(QItemSelection,QItemSelection)), this, SLOT(listSelectionChanged(QItemSelection,QItemSelection)));

}


DCAssignCellCodeClassDialog::~DCAssignCellCodeClassDialog()
{
    if (d_tableModel)
        d_tableModel->deleteLater();
}

void DCAssignCellCodeClassDialog::updateClassList()
{
    d_tableModel->removeAllItems();
    const TKCellCodeMap *cellcodes = d_container->getCellCodes();
    TKCellCode *emtpyCellCodeClass = d_container->getEmptyCellCodeClass();
    for ( TKCellCodeMap::const_iterator it = cellcodes->begin(); it != cellcodes->end(); ++it ) {
        if (it->second != emtpyCellCodeClass)
        {
            QStringList items;
            items << QString::fromStdString(it->first);
            d_tableModel->insertStringList(items);
        }
    }
}

DCCellCode* DCAssignCellCodeClassDialog::getSelectedCellCodeClass() const
{
    if (d_selectedCellCodeClassName.length()>0)
        return dynamic_cast<DCCellCode*>(d_container->getCellCode(d_selectedCellCodeClassName.toStdString()));
    else
        return NULL;

}

void DCAssignCellCodeClassDialog::okButtonClicked()
{
    done(true);
}

void DCAssignCellCodeClassDialog::cancelButtonClicked()
{
    d_selectedCellCodeClassName = "";
    done(false);
}

void DCAssignCellCodeClassDialog::addNewClicked()
{
    DCAddCellCodeClassDialog dialog(d_creator, "");
    dialog.exec();
    updateClassList();
    QString classname = dialog.getAddedCellCodeClassName();
    if (classname.length()>0)
    {
        int cnt = d_tableModel->rowCount();
        for (int i = 0; i < cnt; i++)
        {
            QString s = d_tableModel->data(d_tableModel->index(i,0), Qt::DisplayRole).toString();
            if (s == classname)
            {
                d_table->selectRow(i);
                break;
            }
        }
    }
}

void DCAssignCellCodeClassDialog::listSelectionChanged(const QItemSelection &selected, const QItemSelection &deselected)
{
    (void)deselected;

    if (selected.count()>0)
    {
        d_selectedCellCodeClassName = d_tableModel->data(selected.at(0).indexes().at(0), Qt::DisplayRole).toString();
        d_okButton->setEnabled(true);
    }
    else
    {
        d_okButton->setEnabled(false);
    }
}
