//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCAXONTERMINAL_H
#define DCAXONTERMINAL_H

#include "TKAxonTerminal.h"

#include <QList>

class DCAxon;
class DCVCAxonTerminal;
class DCVComponent;
class DCReceptor;

class DCAxonTerminal : public TKAxonTerminal
{
    friend struct DCComponentUtil;
    DCAxonTerminal(DCAxon *theOwner);
    void bindComponent(DCVComponent *component) { mVComponent = component; }

    DCVComponent *mVComponent;
    bool mIsViewReceptorPointUpdated;
    bool mIsViewAxonPointUpdated;
    float  mViewAxonPointMatrix[16];
    float  mViewReceptorPointMatrix[16];

public:
    virtual ~DCAxonTerminal();

    DCReceptor*     getTarget() const;
    DCVComponent*   getVComponent() const { return mVComponent; }
    bool            getIsViewAxonPointUpdated() const { return mIsViewAxonPointUpdated; }
    bool            getIsViewReceptorPointUpdated() const { return mIsViewReceptorPointUpdated; }
    const float*    getViewAxonPointMatrix() const { return mViewAxonPointMatrix; }
    const float*    getViewReceptorPointMatrix() const { return mViewReceptorPointMatrix; }

    void setViewMatrixForAxonPoint(const float matrix[16]);
    void setViewMatrixForReceptorPoint(const float matrix[16]);
    void resetViewPoinMatrices();
};

#endif // DCAXONTERMINAL_H
