//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 12/31/2011.
//

#import "SourceViewWindowController.h"
#import "Controller.h"

@implementation SourceViewWindowController


-(id)initWithTitleAndOwner:(NSString*)title
                    owner:(Controller*)_owner
{
    windowTitle = title;
    
    if (![super initWithWindowNibName:@"SourceViewWindow"])
        return nil;
    
    owner = _owner;
    isEditing = false;
    _isPenddingSaveAction = false;
    
    return self;
}


- (void)windowDidLoad
{
    [super windowDidLoad];
    [[self window] setTitle: windowTitle];  
    
    [uiStartupScript setString:startupScript];
    [uiCellCode setString:cellCode];
    [uiClassName setObjectValue:className];
    
    [closeButton setEnabled:YES];
    [cancelButton  setEnabled:NO];
    if ([owner isRunning])
    {
        [editButton  setEnabled:NO];
    }
    else
    {
        [editButton  setEnabled:YES];        
    }
    [saveButton  setEnabled:NO];
    
    [uiStartupScript setEditable:NO];
    [uiCellCode setEditable:NO];
}

-(void)updateUIState
{
    if ([owner isRunning])
    {
        [editButton  setEnabled:NO];
        [saveButton  setEnabled:NO];        
    }
    else
    {
        if (isEditing)
        {
            [editButton  setEnabled:NO];
            [saveButton  setEnabled:YES];        
        }
        else
        {
            [editButton  setEnabled:YES];
            [saveButton  setEnabled:NO];                    
        }
    }
}

-(void)setCellCode:(NSString*)code 
         className:(NSString*)name
{
    
    cellCode = code;
    className = name;
    if (uiCellCode != nil)
    {
        [uiCellCode setString:cellCode];
        [uiClassName setObjectValue:className];        
    }
        
}

-(void)setStartupScript:(NSString*)code
{
    startupScript = code;
    if (uiStartupScript != nil)
    {
        [uiStartupScript setString:startupScript];
    }
}

-(IBAction) doCloseAction:(id)sender
{
    [[self window]orderOut:nil];
    
}

-(IBAction) doCancelAction:(id)sender
{
    [[self window]orderOut:nil];
    
}

-(IBAction) doEditAction:(id)sender
{
    isEditing = true;

    [uiStartupScript setEditable:YES];
    [uiCellCode setEditable:YES];
    
    [closeButton setEnabled:NO];
    [editButton  setEnabled:NO];
    [saveButton  setEnabled:YES];
    [cancelButton  setEnabled:YES];
}

-(IBAction) doSaveAction:(id)sender
{
    isEditing = false;
    _isPenddingSaveAction = true;

    [uiStartupScript setEditable:NO];
    [uiCellCode setEditable:NO];

    [closeButton setEnabled:YES];
    [editButton  setEnabled:YES];
    [saveButton  setEnabled:NO];
    [cancelButton  setEnabled:NO];
    
    [owner updateCodeFromSourceCodeView];
}

-(bool)isPenddingSaveAction
{
    return _isPenddingSaveAction;
}

-(void)saveActionCommitted
{
    _isPenddingSaveAction = false;
}

-(NSString*)getStartupScript
{
    return [uiStartupScript string];
}

-(NSString*)getCellCode
{
    return [uiCellCode string];        
    
}

@end
