//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 12/27/11.
//

#include "dennco.h"

#import "Controller.h"
#import "SourceViewWindowController.h"

#include "ConsoleUIOut.h"
#include "DNTimeKeeper.h"
#include "DNUtils.h"

@implementation Controller

- (id)init
{
    self = [super init];
    if (self != nil) {
        self->tickInterval = 1.0;
        self->doExit = true;
    }
    
    console = new ConsoleUIOut(self);
    TKLog::setDestination((TKConsole*)console);
    
    
    return self;
}

-(void)awakeFromNib
{
    container = 0;
    _isRunning = false;
    sampleSelection = 1;

    [self setupSampleCode:nil];
    
    ((ConsoleUIOut*)console)->setTextView(uiConsole);
}

-(IBAction)startAction:(id)sender
{
    ((ConsoleUIOut*)console)->clearAll();
    [uiStart setEnabled:NO];
    [uiStop  setEnabled:YES];
    [uiTFTickInterval setEditable:NO];
    
    if (doExit)
    {
        if (container)
            delete (TKJSContainer*)container;
        
        doExit = false;
        _isRunning = true;
        [self updateSourceViewUIState];
        [self setupContainer];
        [NSThread detachNewThreadSelector:@selector(doTickThread) toTarget:self withObject:nil];        
    }
}


-(bool)isRunning
{
    return _isRunning;
}

-(void) showConsoleBottom
{
    NSRange theEnd=NSMakeRange([[uiConsole string] length],0);
    [uiConsole scrollRangeToVisible:theEnd];
}

-(void)updateSourceViewUIState
{
    if (sourceViewCell11)
    {
        [sourceViewCell11 updateUIState];
    }
    if (sourceViewCell12)
    {
        [sourceViewCell12 updateUIState];
    }
    if (sourceViewCell13)
    {
        [sourceViewCell13 updateUIState];
    }
    if (sourceViewCell21)
    {
        [sourceViewCell21 updateUIState];
    }
    if (sourceViewCell22)
    {
        [sourceViewCell22 updateUIState];
    }
    if (sourceViewCell31)
    {
        [sourceViewCell31 updateUIState];
    }
}

-(void)updateCodeFromSourceCodeView
{
    if (sourceViewCell11)
    {
        if ([sourceViewCell11 isPenddingSaveAction])
        {
            startupScript11 = [sourceViewCell11 getStartupScript];
            layer1code = [sourceViewCell11 getCellCode];
            [sourceViewCell11 saveActionCommitted];
        }
    }
    if (sourceViewCell12)
    {
        if ([sourceViewCell12 isPenddingSaveAction])
        {
            startupScript12 = [sourceViewCell12 getStartupScript];
            layer1code = [sourceViewCell12 getCellCode];            
            [sourceViewCell12 saveActionCommitted];
        }
    }
    if (sourceViewCell13)
    {
        if ([sourceViewCell13 isPenddingSaveAction])
        {
            startupScript13 = [sourceViewCell13 getStartupScript];
            layer1code = [sourceViewCell13 getCellCode];
            [sourceViewCell13 saveActionCommitted];
        }
    }
    if (sourceViewCell21)
    {
        if ([sourceViewCell21 isPenddingSaveAction])
        {
            startupScript21 = [sourceViewCell21 getStartupScript];
            layer2code = [sourceViewCell21 getCellCode];
            [sourceViewCell21 saveActionCommitted];
        }
    }
    if (sourceViewCell22)
    {
        if ([sourceViewCell22 isPenddingSaveAction])
        {
            startupScript22 = [sourceViewCell22 getStartupScript];
            layer2code = [sourceViewCell22 getCellCode];
            [sourceViewCell22 saveActionCommitted];
        }
    }
    if (sourceViewCell31)
    {
        if ([sourceViewCell31 isPenddingSaveAction])
        {
            startupScript31 = [sourceViewCell31 getStartupScript];
            layer3code = [sourceViewCell31 getCellCode];
            [sourceViewCell31 saveActionCommitted];
        }
    }
    
    [self updateCodeInSourceCodeView];
    
}

-(void) updateCodeInSourceCodeView
{
    if (sourceViewCell11)
    {
        [sourceViewCell11 setCellCode:layer1code className:@"layer1code"];
        [sourceViewCell11 setStartupScript:startupScript11];
    }
    if (sourceViewCell12)
    {
        [sourceViewCell12 setCellCode:layer1code className:@"layer1code"];
        [sourceViewCell12 setStartupScript:startupScript12];
    }
    if (sourceViewCell13)
    {
        [sourceViewCell13 setCellCode:layer1code className:@"layer1code"];
        [sourceViewCell13 setStartupScript:startupScript13];
    }
    if (sourceViewCell21)
    {
        [sourceViewCell21 setCellCode:layer2code className:@"layer2code"];
        [sourceViewCell21 setStartupScript:startupScript21];
    }
    if (sourceViewCell22)
    {
        [sourceViewCell22 setCellCode:layer2code className:@"layer2code"];
        [sourceViewCell22 setStartupScript:startupScript22];
    }
    if (sourceViewCell31)
    {
        [sourceViewCell31 setCellCode:layer3code className:@"layer3code"];
        [sourceViewCell31 setStartupScript:startupScript31];
    }
    
}



-(IBAction)stopAction:(id)sender
{
    doExit = true;
    [uiStart setEnabled:YES];
    [uiStop  setEnabled:NO];
    [uiTFTickInterval setEditable:YES];
}

-(IBAction)setupSampleCode:(id)sender
{
    
    if (sender != nil)
    {
        NSInteger sl = [sender indexOfSelectedItem];
        if (sl >= 0.0)
        {
            sampleSelection = (int)sl + 1; 
        }
        
    }
    NSString *layer1_path;
    NSString *layer2_path;
    NSString *layer3_path;
    
    NSString *startup11_path;
    NSString *startup12_path;
    NSString *startup13_path;
    NSString *startup21_path;
    NSString *startup22_path;
    NSString *startup31_path;
    
    switch(sampleSelection)
    {
        case 1:
            layer1_path = [[NSBundle mainBundle] pathForResource:@"layer1_1" ofType:@"js"];
            layer2_path = [[NSBundle mainBundle] pathForResource:@"layer2_1" ofType:@"js"];
            layer3_path = [[NSBundle mainBundle] pathForResource:@"layer3_1" ofType:@"js"];
            startup11_path = [[NSBundle mainBundle] pathForResource:@"startup11_1" ofType:@"js"];
            startup12_path = [[NSBundle mainBundle] pathForResource:@"startup12_1" ofType:@"js"];
            startup13_path = [[NSBundle mainBundle] pathForResource:@"startup13_1" ofType:@"js"];
            startup21_path = [[NSBundle mainBundle] pathForResource:@"startup21_1" ofType:@"js"];
            startup22_path = [[NSBundle mainBundle] pathForResource:@"startup22_1" ofType:@"js"];
            startup31_path = [[NSBundle mainBundle] pathForResource:@"startup31_1" ofType:@"js"];
            break;
        case 2:
            layer1_path = [[NSBundle mainBundle] pathForResource:@"layer1_2" ofType:@"js"];
            layer2_path = [[NSBundle mainBundle] pathForResource:@"layer2_2" ofType:@"js"];
            layer3_path = [[NSBundle mainBundle] pathForResource:@"layer3_2" ofType:@"js"];
            startup11_path = [[NSBundle mainBundle] pathForResource:@"startup11_2" ofType:@"js"];
            startup12_path = [[NSBundle mainBundle] pathForResource:@"startup12_2" ofType:@"js"];
            startup13_path = [[NSBundle mainBundle] pathForResource:@"startup13_2" ofType:@"js"];
            startup21_path = [[NSBundle mainBundle] pathForResource:@"startup21_2" ofType:@"js"];
            startup22_path = [[NSBundle mainBundle] pathForResource:@"startup22_2" ofType:@"js"];
            startup31_path = [[NSBundle mainBundle] pathForResource:@"startup31_2" ofType:@"js"];
            break;
    }
    
    layer1code =  [[NSString alloc]initWithContentsOfFile:layer1_path encoding:NSUTF8StringEncoding error:NULL];    
    layer2code =  [[NSString alloc]initWithContentsOfFile:layer2_path encoding:NSUTF8StringEncoding error:NULL];
    layer3code =  [[NSString alloc]initWithContentsOfFile:layer3_path encoding:NSUTF8StringEncoding error:NULL];
    startupScript11 = [[NSString alloc]initWithContentsOfFile:startup11_path encoding:NSUTF8StringEncoding error:NULL];
    startupScript12 = [[NSString alloc]initWithContentsOfFile:startup12_path encoding:NSUTF8StringEncoding error:NULL];
    startupScript13 = [[NSString alloc]initWithContentsOfFile:startup13_path encoding:NSUTF8StringEncoding error:NULL];
    startupScript21 = [[NSString alloc]initWithContentsOfFile:startup21_path encoding:NSUTF8StringEncoding error:NULL];
    startupScript22 = [[NSString alloc]initWithContentsOfFile:startup22_path encoding:NSUTF8StringEncoding error:NULL];
    startupScript31 = [[NSString alloc]initWithContentsOfFile:startup31_path encoding:NSUTF8StringEncoding error:NULL];

    [self updateCodeInSourceCodeView];
    [self stopAction:nil];
}


-(void)setupContainer
{
    TKJSContainer *ctn = new TKJSContainer();
    container = ctn;

    std::string jslayer1code =  [layer1code UTF8String];
    std::string jslayer2code =  [layer2code UTF8String];
    std::string jslayer3code =  [layer3code UTF8String];
    
    const char *cstrStartupScript11 = [startupScript11 UTF8String];
    const char *cstrStartupScript12 = [startupScript12 UTF8String];
    const char *cstrStartupScript13 = [startupScript13 UTF8String];
    const char *cstrStartupScript21 = [startupScript21 UTF8String];
    const char *cstrStartupScript22 = [startupScript22 UTF8String];
    const char *cstrStartupScript31 = [startupScript31 UTF8String];
    

    TKCellCode *uiCode = ctn->createCellCode("layer1code", TKJSContainer::CELLTYPE_UIBASE, "");
    TKCellCode *layer1Code = ctn->createCellCode("layer1code", TKJSContainer::CELLTYPE_JSBASIC, jslayer1code);
    TKCellCode *layer2Code = ctn->createCellCode("layer2code", TKJSContainer::CELLTYPE_JSBASIC, jslayer2code);
    TKCellCode *layer3Code = ctn->createCellCode("layer3code", TKJSContainer::CELLTYPE_JSBASIC, jslayer3code);

	signal1 = ctn->createCell("","signal1", uiCode,"");
	signal2 = ctn->createCell("","signal2", uiCode,"");
	signal3 = ctn->createCell("","signal3", uiCode,"");
    
	TKCell *cell11 = ctn->createCell("","cell1-1", layer1Code, cstrStartupScript11);
	TKCell *cell12 = ctn->createCell("","cell1-2", layer1Code, cstrStartupScript12);
	TKCell *cell13 = ctn->createCell("","cell1-3", layer1Code, cstrStartupScript13);

	TKCell *cell21 = ctn->createCell("","cell2-1", layer2Code, cstrStartupScript21);
	TKCell *cell22 = ctn->createCell("","cell2-2", layer2Code, cstrStartupScript22);

	TKCell *cell31 = ctn->createCell("","cell3-1", layer3Code, cstrStartupScript31);


	((TKCell*)signal1)->connectTo("signal1", cell11);
	((TKCell*)signal1)->connectTo("signal1", cell12);
	((TKCell*)signal1)->connectTo("signal1", cell13);

	((TKCell*)signal2)->connectTo("signal2", cell11);
	((TKCell*)signal2)->connectTo("signal2", cell12);
	((TKCell*)signal2)->connectTo("signal2", cell13);

	((TKCell*)signal3)->connectTo("signal3", cell11);
	((TKCell*)signal3)->connectTo("signal3", cell12);
	((TKCell*)signal3)->connectTo("signal3", cell13);    
    
	cell11->connectTo("Cell 1-1", cell21);
	cell11->connectTo("Cell 1-1", cell22);

	cell12->connectTo("Cell 1-2", cell21);
	cell12->connectTo("Cell 1-2", cell22);

	cell13->connectTo("Cell 1-3", cell21);
	cell13->connectTo("Cell 1-3", cell22);
        
	cell21->connectTo("Cell 2-1", cell31);

	cell22->connectTo("Cell 2-2", cell31);
    
}

float cv11;
float cv12;
float cv13;
float cv21;
float cv22;
float cv31;


-(void)doTickThread
{
    TKJSContainer *ctn = (TKJSContainer *) container;
    tickInterval = [uiTFTickInterval floatValue];
    
    DNTimeKeeper *timeKeeper = new DNTimeKeeper();
    timeKeeper->setIntevalSec(tickInterval);    
    
    const TKCellMap *cells = ctn->getCells();

    TKCellMap::const_iterator it11 = cells->find(getFQNString("","cell1-1"));
    TKCellMap::const_iterator it12 = cells->find(getFQNString("","cell1-2"));
    TKCellMap::const_iterator it13 = cells->find(getFQNString("","cell1-3"));
    TKCellMap::const_iterator it21 = cells->find(getFQNString("","cell2-1"));
    TKCellMap::const_iterator it22 = cells->find(getFQNString("","cell2-2"));
    TKCellMap::const_iterator it31 = cells->find(getFQNString("","cell3-1"));

    timeKeeper->start();
    
    while(doExit == false)
    {
        float ct = timeKeeper->getTickTime();
        NSString *cstr = [[NSString alloc]initWithFormat:@"%.3f", ct];
        [uiTFCurrentTime performSelectorOnMainThread:@selector(setObjectValue:) withObject:cstr waitUntilDone:NO]; 
        
        float s1 = [uiSignal1 state] == NSOnState ? 1.0 : 0.0;
        float s2 = [uiSignal2 state] == NSOnState ? 1.0 : 0.0;
        float s3 = [uiSignal3 state] == NSOnState ? 1.0 : 0.0;
        
        ((TKCell*)signal1)->setAxonValue(s1);
        ((TKCell*)signal2)->setAxonValue(s2);
        ((TKCell*)signal3)->setAxonValue(s3);
        
        float gv = [uiSliderForAGlobalProperty floatValue];
        ((TKJSContainer*)container)->setValue("property1", gv);
        
        ctn->doTick((float)ct);
        
        cv11 = it11->second->getAxonValue();
        cv12 = it12->second->getAxonValue();
        cv13 = it13->second->getAxonValue();
        cv21 = it21->second->getAxonValue();
        cv22 = it22->second->getAxonValue();
        cv31 = it31->second->getAxonValue();
        
        
        [self performSelectorOnMainThread:@selector(updateUICellValue) withObject:nil waitUntilDone:NO];
                        
        timeKeeper->sleepUntilNextInterval();
    }
 
    _isRunning = false;
    [self performSelectorOnMainThread:@selector(updateSourceViewUIState) withObject:nil waitUntilDone:NO];
    
    delete timeKeeper;
    
    [NSThread exit];
        
}

-(void)updateUICellValue
{
    [uiTFCell11 setObjectValue: [[NSString alloc]initWithFormat:@"%.3f", cv11]];
    [uiTFCell12 setObjectValue: [[NSString alloc]initWithFormat:@"%.3f", cv12]];
    [uiTFCell13 setObjectValue: [[NSString alloc]initWithFormat:@"%.3f", cv13]];
    [uiTFCell21 setObjectValue: [[NSString alloc]initWithFormat:@"%.3f", cv21]];
    [uiTFCell22 setObjectValue: [[NSString alloc]initWithFormat:@"%.3f", cv22]];
    [uiTFCell31 setObjectValue: [[NSString alloc]initWithFormat:@"%.3f", cv31]];
    
    [uiSlider setFloatValue:cv31];
    
}

//SourceView
-(IBAction)cell11Action:(id)sender
{
    if (!sourceViewCell11)
    {
        sourceViewCell11 = [[SourceViewWindowController alloc]
                            initWithTitleAndOwner:@"SourceView - Cell 1-1"
                                            owner:self];
    }
    
    [sourceViewCell11 setCellCode:layer1code className:@"layer1code"];
    [sourceViewCell11 setStartupScript:startupScript11];
    [sourceViewCell11 showWindow:self];
}

-(IBAction)cell12Action:(id)sender
{
    if (!sourceViewCell12)
    {
        sourceViewCell12 = [[SourceViewWindowController alloc]
                            initWithTitleAndOwner:@"SourceView - Cell 1-2"
                                            owner:self];
    }
    [sourceViewCell12 setCellCode:layer1code className:@"layer1code"];
    [sourceViewCell12 setStartupScript:startupScript12];
    [sourceViewCell12 showWindow:self];    
}

-(IBAction)cell13Action:(id)sender
{
    if (!sourceViewCell13)
    {
        sourceViewCell13 = [[SourceViewWindowController alloc]
                            initWithTitleAndOwner:@"SourceView - Cell 1-3"
                                            owner:self];
    }
    [sourceViewCell13 setCellCode:layer1code className:@"layer1code"];
    [sourceViewCell13 setStartupScript:startupScript13];
    [sourceViewCell13 showWindow:self];
}

-(IBAction)cell21Action:(id)sender
{
    if (!sourceViewCell21)
    {
        sourceViewCell21 = [[SourceViewWindowController alloc]
                            initWithTitleAndOwner:@"SourceView - Cell 2-1"
                                            owner:self];
    }
    [sourceViewCell21 setCellCode:layer2code className:@"layer2code"];
    [sourceViewCell21 setStartupScript:startupScript21];
    [sourceViewCell21 showWindow:self];    
}

-(IBAction)cell22Action:(id)sender
{
    if (!sourceViewCell22)
    {
        sourceViewCell22 = [[SourceViewWindowController alloc]
                            initWithTitleAndOwner:@"SourceView - Cell 2-2"
                                            owner:self];
    }
    [sourceViewCell22 setCellCode:layer2code className:@"layer2code"];
    [sourceViewCell22 setStartupScript:startupScript22];
    [sourceViewCell22 showWindow:self];

}

-(IBAction)cell31Action:(id)sender
{
    if (!sourceViewCell31)
    {
        sourceViewCell31 = [[SourceViewWindowController alloc]
                            initWithTitleAndOwner:@"SourceView - Cell 3-1"
                                            owner:self];
    }
    [sourceViewCell31 setCellCode:layer3code className:@"layer3code"];
    [sourceViewCell31 setStartupScript:startupScript31];
    [sourceViewCell31 showWindow:self];

}


//delegate methods for mainwindow
- (void)windowWillClose:(NSNotification *)aNotification
{
    doExit = true;
}

- (BOOL)windowShouldClose:(id)sender
{
    [NSApp terminate:self];
    return YES;
}
@end
