//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 12/27/2011.
//

#import <Cocoa/Cocoa.h>

@class SourceViewWindowController;

@interface Controller : NSObject
{
    void    *container;
    float   tickInterval;
    bool    doExit;
    bool    _isRunning;
    IBOutlet NSTextField        *uiTFTickInterval;
    IBOutlet NSTextField        *uiTFCurrentTime;
    IBOutlet NSTextField        *uiTFCell11;
    IBOutlet NSTextField        *uiTFCell12;
    IBOutlet NSTextField        *uiTFCell13;
    IBOutlet NSTextField        *uiTFCell21;
    IBOutlet NSTextField        *uiTFCell22;
    IBOutlet NSTextField        *uiTFCell31;
    IBOutlet NSSlider           *uiSlider;
    IBOutlet NSSlider           *uiSliderForAGlobalProperty;
    IBOutlet NSTextView         *uiConsole;
    
    IBOutlet NSButton           *uiSignal1;
    IBOutlet NSButton           *uiSignal2;
    IBOutlet NSButton           *uiSignal3;
    
    IBOutlet NSButton           *uiStart;
    IBOutlet NSButton           *uiStop;
    
    IBOutlet NSComboBox         *uiSampleSelection;
        
    void                        *signal1;
    void                        *signal2;
    void                        *signal3;
    
    //SourceView
    SourceViewWindowController  *sourceViewCell11;
    SourceViewWindowController  *sourceViewCell12;
    SourceViewWindowController  *sourceViewCell13;
    SourceViewWindowController  *sourceViewCell21;
    SourceViewWindowController  *sourceViewCell22;
    SourceViewWindowController  *sourceViewCell31;

    int                         sampleSelection;

    NSString                    *layer1code;
    NSString                    *layer2code;
    NSString                    *layer3code;

    NSString                    *startupScript11;
    NSString                    *startupScript12;
    NSString                    *startupScript13;
    NSString                    *startupScript21;
    NSString                    *startupScript22;
    NSString                    *startupScript31;
    
    //console
    void                        *console;

}
-(IBAction)startAction:(id)sender;
-(IBAction)stopAction:(id)sender;

-(id)init;
-(void)setupContainer;
-(void)doTickThread;
-(void)awakeFromNib;

-(bool)isRunning;
-(void)updateSourceViewUIState;
-(void)updateCodeFromSourceCodeView;
-(void)updateCodeInSourceCodeView;

-(void)updateUICellValue;

-(IBAction)cell11Action:(id)sender;
-(IBAction)cell12Action:(id)sender;
-(IBAction)cell13Action:(id)sender;
-(IBAction)cell21Action:(id)sender;
-(IBAction)cell22Action:(id)sender;
-(IBAction)cell31Action:(id)sender;

-(IBAction)setupSampleCode:(id)sender;

//console
-(void) showConsoleBottom;

//
- (void)windowWillClose:(NSNotification *)aNotification;
- (BOOL)windowShouldClose:(id)sender;

@end
