

#include "dennco_plugin.h"
#include "ui_dialog.h"

#include <QDialog>
#include <QDebug>


class PluginDialog;

static PluginDialog *s_dialog = NULL;

class PluginDialog : public QDialog
{
    Ui::Dialog *d_ui;

public:

    static void construct()
    {
        if (!s_dialog)
        {
            s_dialog = new PluginDialog;
        }
    }

    static PluginDialog* instance()
    {
        return s_dialog;
    }

    static void destruct()
    {
        if (s_dialog)
        {
            s_dialog->close();
            s_dialog->deleteLater();
            s_dialog = NULL;
        }
    }

    PluginDialog()
    {
        d_ui = new Ui::Dialog;
        d_ui->setupUi(this);
    }

    virtual ~PluginDialog()
    {
    }

    void setValue1(float v)
    {
        d_ui->DenncoToPlugin1->setValue(v*100);
    }

    void setValue2(float v)
    {
        d_ui->DenncoToPlugin2->setValue(v*100);
    }

    float getValue1() const
    {
        return d_ui->PluginToDennco1->value() / 100.0f;
    }

    float getValue2() const
    {
        return d_ui->PluginToDennco2->value() / 100.0f;
    }

};

PLUGINAPI bool init()
{
    PluginDialog::construct();
    PluginDialog::instance()->show();

    return true;
}

PLUGINAPI bool unload()
{
    PluginDialog::destruct();

    return true;
}

PLUGINAPI float queryPluginValue(const char* name)
{
    if (strcmp("input1", name) == 0)
    {
        return PluginDialog::instance()->getValue1();
    }
    else if (strcmp("input2", name) == 0)
    {
        return PluginDialog::instance()->getValue2();
    }
    else
    {
        QString msg;
        msg.sprintf("SamplePlugin1: queryPluginValue: %s not found!\n", name);
        qDebug() << msg;
    }
    return 0.0f;
}

PLUGINAPI void  setValueToPlugin(const char* name, float value)
{
    if (strcmp("output1", name) == 0)
    {
        PluginDialog::instance()->setValue1(value);
    }
    else if (strcmp("output2", name) == 0)
    {
        PluginDialog::instance()->setValue2(value);
    }
    else
    {
        QString msg;
        msg.sprintf("SamplePlugin1: setValueToPlugin: %s not found!\n", name);
        qDebug() << msg;
    }
}
