//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 2/14/2012.
//

#import "SimpleHTTPServerController.h"
#import "SimpleHTTPServer.h"

@implementation SimpleHTTPServerController
- (id) initWithTCPPort:(unsigned int)port_number dnserver:(DNHTTPServer*) _dnserver requestHandler:(DNClientRequestHandler) handler
{
    self = [super init];
    if (self)
    {
        self->server = [[SimpleHTTPServer alloc] initWithTCPPort:port_number delegate:self];
        self->requestHandler = handler;
        self->dnserver = _dnserver;
    }
    return self;
}

-(void)dealloc
{
}

//interface methods
- (void)replyWithStatusCode:(int)code message:(NSString *)message
{
    [server replyWithStatusCode:code message:message];
}

- (void)replyWithData:(NSData *)data MIMEType:(NSString *)type
{
    [server replyWithData:data MIMEType:type];
}


- (void)stop
{
    
}


//delegate methods
- (void)processURL:(NSURL *)path body:(NSString*) body connection:(SimpleHTTPConnection *)connection
{
    const char *cpath = [[path absoluteString]UTF8String];
    const char *cbody = [body UTF8String];
    requestHandler(dnserver, cpath , cbody);
}

- (void)stopProcessing
{
    
}

@end
