//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 1/7/2012.
//

#include "DNXML.h"
#include "DNXMLImpl.h"
#include "DNXMLElement.h"
#include "OSXDNXMLImpl.h"
#include "TKLog.h"
#include "TKDebug.h"

#include <map>

//static 
DNXMLImpl* DNXMLImpl::createXMLFromFileImpl(const char *docRoot, const char *path)
{
    NSString *file = [[NSString alloc]initWithFormat:@"%s/%s", docRoot,path];
    
    NSXMLDocument *xmlDoc;
    NSError *err=nil;
    NSURL *furl = [NSURL fileURLWithPath:file];
    if (!furl) {
        TKLog::printf("Can't create an URL from file %s.", path);
        return 0;
    }
    xmlDoc = [[NSXMLDocument alloc] initWithContentsOfURL:furl
                                                  options:(NSXMLNodePreserveWhitespace|NSXMLNodePreserveCDATA)
                                                    error:&err];
    if (xmlDoc == nil) {
        xmlDoc = [[NSXMLDocument alloc] initWithContentsOfURL:furl
                                                      options:NSXMLDocumentTidyXML
                                                        error:&err];
    }
    if (xmlDoc == nil)  {
        TKLog::printf("Can't parse xml file %s.", path);
        return 0;
    }

    return new OSXDNXMLImpl(xmlDoc);
}

OSXDNXMLImpl::OSXDNXMLImpl(NSXMLDocument *doc):
mDocument(doc),mRootElement(nil)
{
    
}

OSXDNXMLImpl::~OSXDNXMLImpl()
{
	if (mRootElement)
		delete mRootElement;
}


DNXMLElement* OSXDNXMLImpl::getRoot()
{
    if (mRootElement)
        return mRootElement;
    
    NSXMLNode *rootNode = [mDocument rootElement];
    NSXMLNode *aNode = rootNode;

    std::map<unsigned long, DNXMLElement*> elementMap;
    
    int depth = 0;
    
    while(aNode)
    {
        if ( [aNode kind] == NSXMLElementKind )
        {
            
            NSString *nname = [aNode name];
            const char *cname;
            if (nname)
            {
                cname = [nname UTF8String];
            }
            else
            {
                cname = "";
            }
            DNXMLElement *dnelement = new DNXMLElement(cname);
            dnelement->depth = depth;
            NSXMLElement *aElement = (NSXMLElement*) aNode;
            for( NSXMLNode *attribute in [aElement attributes] ) {
                const char *name = [[attribute name] UTF8String];
                const char *value = [[attribute stringValue] UTF8String];
                dnelement->setAttribute(name, value);
            }
                
            elementMap.insert(std::map<unsigned long, DNXMLElement*>::value_type((unsigned long)aNode,dnelement)); 

            NSXMLNode *parent = [aNode parent];
            if (parent)
            {

                DNXMLElement *dnparent = elementMap[(unsigned long)parent];
                
                if (dnparent)
                {
                    dnelement->outer = dnparent;
                    if (!dnparent->inner)
                    {
                        dnparent->inner = dnelement;
                    }
                }
                else
                {
                    mRootElement = dnelement;
                }
            }
            else
            {
                //?
                mRootElement = dnelement;
            }
                
            NSXMLNode *prevSibling = [aNode previousSibling];
            while (prevSibling)
            {
                if ([prevSibling kind] == NSXMLElementKind)
                {
                    DNXMLElement *dnprev = elementMap[(unsigned long)prevSibling];
                        
                    TKASSERT(dnprev);
                    dnprev->next = dnelement;
                    break;
                }
                prevSibling = [prevSibling previousSibling];
            }
            
        }
        else if ( [aNode kind] == NSXMLTextKind )
        {
            NSXMLNode *parent = [aNode parent];
            if (parent)
            {
                DNXMLElement *dnparent = elementMap[(unsigned long)parent];
                dnparent->text = [[aNode stringValue] UTF8String];
            }
        }
        
        //go to next
        if ([aNode childCount]>0)
        {
            depth ++;
            aNode = [aNode childAtIndex:0];
        }
        else
        {
            while (![aNode nextSibling] && aNode != rootNode)
            {
                depth--;
                aNode = [aNode parent];
            }
            
            if (aNode == rootNode) 
            {
                aNode = nil;
            }
            else
            {
                aNode = [aNode nextSibling];
            }
        }
    }
    return mRootElement;
}
