//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 1/29/2012.
//

#ifndef dennco_OSXDNSimpleHTTPServerImpl_h
#define dennco_OSXDNSimpleHTTPServerImpl_h

#import "SimpleHTTPServerController.h"

#include "DNHTTPServerImpl.h"
#include "DNHTTPServer.h"

class DNEngine;

class OSXDNSimpleHTTPServerImpl : public DNHTTPServerImpl
{
public:
    OSXDNSimpleHTTPServerImpl(DNHTTPServer *owner, DNClientRequestHandler handler);
    virtual ~OSXDNSimpleHTTPServerImpl();
    
    virtual bool                isRunning();
    virtual void                start();
    virtual void                stop();
    virtual void                setPortNumber(unsigned int portNumber);
    virtual void                replyWithStatusCode(int code, const char* message);
    virtual void                replyWithFile(const char* filePath);


private:
    SimpleHTTPServerController  *controller;
    DNHTTPServer                *mOwner;
    unsigned int                mPortNumber;
    DNClientRequestHandler      mHandler;
    bool                        mIsRunning;
    
};

#endif
