//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 1/7/2012.
//

#ifndef dennco_OSXDNDirectoryImpl_h
#define dennco_OSXDNDirectoryImpl_h

#include "DNDirectory.h"
#include "DNFileList.h"

#import <Foundation/Foundation.h>

class OSXDNDirectoryImpl : public DNDirectoryImpl
{
public:
    virtual const DNFileList*   getFileList(const char *filter);
    
    OSXDNDirectoryImpl(const char *dir);
    virtual ~OSXDNDirectoryImpl();
    
private:
    NSString *mRootDir;
    DNFileList *mFileList;
    
    void cleanFileList();
    
};

#endif
