//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 1/17/2013.
//
#include "dnpluginoutputcell.h"

#include "dnplugin.h"
#include "dnpluginmanager.h"
#include "TKReceptor.h"
#include "TKAxon.h"
#include "DNUtils.h"

#include <limits>

DNPluginOutputCell::DNPluginOutputCell(TKContainer *container, std::string location, std::string name, std::string pluginName, std::string valueName)
    : DNCellInterfaceable(container, location, name, false, true),
      d_plugin(NULL), d_valueName(valueName), d_outputValue(std::numeric_limits<float>::quiet_NaN()), d_wasReady(false)
{
    d_valueIterator = mReceptors.end();
    d_forceUpdateIterator = mReceptors.end();

    d_plugin = DNPluginManager::instance()->getPlugin(pluginName);
    if (!d_plugin)
    {
        std::string message = std::string("Failed to initialize cell '").append(location).append("#").append(name);
        message.append("'\nLoading the specified plugin : '").append(pluginName).append("' failed");
        dnNotifyError("Initialization failed", message);
    }
}

DNPluginOutputCell::~DNPluginOutputCell()
{
}

bool DNPluginOutputCell::doTick(float time)
{
    (void)time;

    float value = 0.0;
    if (d_valueIterator != mReceptors.end())
    {
        value = d_valueIterator->second->getValue();
    }
    else
    {
        d_valueIterator = mReceptors.find("value");
    }

    bool forceUpdate = false;
    if (d_forceUpdateIterator != mReceptors.end())
    {
        forceUpdate = d_forceUpdateIterator->second->getValue() > 0;
    }
    else
    {
        d_forceUpdateIterator = mReceptors.find("forceUpdate");
    }

    mAxon->setValue(value);
    if (d_plugin && d_plugin->getIsValid())
    {
        bool isReady = d_plugin->getIsReady();
        if (isReady && (value != d_outputValue || forceUpdate))
        {
            d_outputValue = value;
            d_plugin->setValueToPlugin(d_valueName.c_str(), value);
        }
        d_wasReady = isReady;
    }
    return true;
}

bool DNPluginOutputCell::doInit()
{
    return true;
}

bool DNPluginOutputCell::doDestroy()
{
    return true;
}

void DNPluginOutputCell::setValue(float value)
{
    (void)value;
}
