//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 1/17/2013.
//
#ifndef DNPLUGIN_H
#define DNPLUGIN_H

class DNPlugin
{
protected:
    typedef bool  (*InitFunction)();
    typedef bool  (*UnloadFunction)();
    typedef bool  (*GetIsReadyFunction)();
    typedef float (*QueryPluginValueFunction)(const char*);
    typedef void  (*SetValueToPluginFunction)(const char*, float);

    bool                        d_isValid;
    bool                        d_isReady;
    InitFunction                d_initFunction;
    UnloadFunction              d_unloadFunction;
    GetIsReadyFunction          d_getIsReadyFunction;
    QueryPluginValueFunction    d_queryPluginValueFunction;
    SetValueToPluginFunction    d_setValueToPluginFunction;

    DNPlugin() :
        d_isValid(false), d_isReady(false), d_initFunction(0), d_unloadFunction(0), d_queryPluginValueFunction(0), d_setValueToPluginFunction(0)
    {}

public:
    virtual ~DNPlugin(){}
    inline bool getIsValid() const { return d_isValid; }
    inline bool getIsReady() const { return d_getIsReadyFunction ? d_getIsReadyFunction() : false; }
    inline bool init() { return d_initFunction ? d_initFunction() : false; }
    inline bool unload() { return d_unloadFunction ? d_unloadFunction() : true; }
    inline float queryPluginValue(const char* name) { return d_isValid ? d_queryPluginValueFunction(name) : 0.0f; }
    inline void setValueToPlugin(const char* name, float value) { if (d_isValid) d_setValueToPluginFunction(name, value); }
};

#endif // DNPLUGIN_H
