//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 2/22/2012.
//
#ifndef DNQSCELLCODE_H
#define DNQSCELLCODE_H

#include "TKCellCode.h"

#include <QtScript/QScriptEngine>
#include <QtScript/QScriptValue>

class DNQSContainer;

class DNQSCellCode : public TKCellCode
{
public:
    DNQSCellCode(std::string name, std::string cellapi, DNQSContainer *container, std::string code);
    virtual ~DNQSCellCode();

    virtual TKCellCodeInstance* createCellCodeInstance(TKCell *owner, const void *data);

private:
    DNQSContainer *mCellContainer;
    QScriptValue  mCellCodeConstructor;
};

#endif // DNQSCELLCODE_H
