//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 2/25/2012.
//
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QQueue>
#include <QLocalServer>

#include "TKConsole.h"
#include "TKLock.h"

class DNEngine;
class TKConsole;
class DNWebInterface;

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow, TKConsole
{
    Q_OBJECT
    
public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

    static QWidget *instance;

protected:
    virtual void closeEvent(QCloseEvent *event);
    virtual void paintEvent(QPaintEvent *event );

private slots:
    void on_chooseDirButton_clicked();
    void on_startButton_clicked();
    void attachWebInterface();
    void adjustWindowSize();

    void onNewRequestFromCreator();

private:
    bool  startEngine();
    bool  stopEngine();
    void  loadUI();
    void  deleteCurrentEngine();

    Ui::MainWindow  *ui;
    DNEngine        *mEngine;
    TKConsole       *mConsole;
    DNWebInterface  *mWebInterface;

    class PendingConsoleMessage
    {
    public:
        TKLog::MessageType  messageType;
        QString             text;
    };

    static QColor NORMAL_COLOR;
    static QColor WARN_COLOR;
    static QColor ERROR_COLOR;

    virtual void vprintf(TKLog::MessageType type, const char *fmt, va_list arg);
    virtual void vDebugPrintf(const char *fmt, va_list arg);
    TKLock       mConsoleLock;
    QQueue<PendingConsoleMessage> mPendingConsoleMessages;

    bool            mControlledByCreator;
    QLocalServer    *mCreatorIPCServer;

signals:
    void consoleUpdated();

};

#endif // MAINWINDOW_H
