//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 12/16/2011.
//

#include "TKJSBasicCell.h"
#include "TKJSCellCode.h"
#include "TKJSContainer.h"
#include "TKJSCellCodeInstance.h"
#include "TKReceptor.h"
#include "TKLock.h"
#include "TKDebug.h"

#include <JavaScriptCore/JavaScriptCore.h>

class TKContainer;

JSClassRef TKJSBasicCell::mJSAPIClass = NULL;
JSStringRef TKJSBasicCell::mJsstrReceptors = NULL;
TKLock TKJSBasicCell::msLock;
JSClassDefinition TKJSBasicCell::mJsClassDef;


//JavaScript API functions

/*JSStaticFunction jsfuncFQN = {"FQN",(JSObjectCallAsFunctionCallback)TKJSBasicCell::jsAPICB_FQN,kJSPropertyAttributeNone};
JSStaticFunction jsfuncSetAxonValue = {"setAxonValue",(JSObjectCallAsFunctionCallback)TKJSBasicCell::jsAPICB_setAxonValue,kJSPropertyAttributeNone};
JSStaticFunction jsfuncGetAxonValue = {"getAxonValue",(JSObjectCallAsFunctionCallback)TKJSBasicCell::jsAPICB_getAxonValue,kJSPropertyAttributeNone};
 */
//JSStaticFunction classFunctions[] = {jsfuncFQN, {0,0,0}};


JSStaticValue jsStaticValueArray[] = { 
    { "axonValue", (JSObjectGetPropertyCallback)TKJSBasicCell::jsAPICB_getAxonValue, (JSObjectSetPropertyCallback)TKJSBasicCell::jsAPICB_setAxonValue, kJSPropertyAttributeNone }, 
    { "name", (JSObjectGetPropertyCallback)TKJSBasicCell::jsAPICB_getName, NULL, kJSPropertyAttributeNone },     
    { "location", (JSObjectGetPropertyCallback)TKJSBasicCell::jsAPICB_getLocation, NULL, kJSPropertyAttributeNone },     
    { 0, 0, 0, 0 } };


const char* JSCLASSNAME = "__TKCLASSDEF_TKJSBasicCell";

TKJSBasicCell::TKJSBasicCell(TKJSContainer *container, std::string location, std::string name, bool canInterface)
:TKJSCellBase(container, location, name, canInterface)
{
    JSContextRef ctx = ((TKJSContainer*)getContainer())->getJSContext();
    
    if (!mJSAPIClass)
    {
        constructJSAPI(ctx);
    }

    mJSAPIInstance = JSObjectMake (ctx, mJSAPIClass, this);
    JSValueProtect(ctx, mJSAPIInstance);
    mJsReceptorValues = JSObjectMake (ctx, NULL, this);
    JSObjectSetProperty(ctx, mJSAPIInstance, mJsstrReceptors, mJsReceptorValues, kJSPropertyAttributeNone, NULL);
    
    JSStringRef jstrName = JSStringCreateWithUTF8CString(name.c_str());
    mJName = JSValueMakeString(ctx, jstrName);
    JSValueProtect(ctx, mJName);
    JSStringRelease(jstrName);

    JSStringRef jstrLocation = JSStringCreateWithUTF8CString(location.c_str());
    mJLocation = JSValueMakeString(ctx, jstrLocation);
    JSValueProtect(ctx, mJLocation);
    JSStringRelease(jstrLocation);

}

TKJSBasicCell::~TKJSBasicCell()
{
    TKJSContainer *container = (TKJSContainer*)getContainer();
    if (container)
    {
        JSContextRef ctx = container->getJSContext();
        if (ctx)
        {
            if (mJSAPIInstance)
            {
                JSValueUnprotect(ctx,mJSAPIInstance);
            }
            if (mJName)
            {
                JSValueUnprotect(ctx, mJName);
            }
            if (mJLocation)
            {
                JSValueUnprotect(ctx, mJLocation);
            }
        }
    }
}

bool TKJSBasicCell::doTick(float time) 
{
    if (!mCellCodeInstance) return false;
    
    //update receptor values
    JSContextRef ctx = ((TKJSContainer*)getContainer())->getJSContext();
    for ( TKReceptorMap::iterator it = mReceptors.begin(); it != mReceptors.end(); ++it ) {
        JSValueRef  jsValue = JSValueMakeNumber(ctx, it->second->getValue());
        JSStringRef jsConnectionName = JSStringCreateWithUTF8CString(it->first.c_str());
        JSObjectSetProperty(ctx, mJsReceptorValues, jsConnectionName, jsValue, kJSPropertyAttributeNone, NULL);
        JSStringRelease(jsConnectionName);
    }

    return mCellCodeInstance->doTick(time);
}

bool TKJSBasicCell::doInit()
{
    if (!mCellCodeInstance) return false;
	return mCellCodeInstance->doInit();
}

bool TKJSBasicCell::doDestroy()
{
    if (!mCellCodeInstance) return false;
	return mCellCodeInstance->doDestroy();
}

void TKJSBasicCell::constructJSAPI(JSContextRef context)
{
    msLock.lock();
    
    if (mJSAPIClass != NULL)
    {
        msLock.unlock();
        return;
    }
    
    mJsClassDef.version = 0;
    mJsClassDef.className = JSCLASSNAME;
    mJsClassDef.parentClass = NULL;
    mJsClassDef.staticValues = jsStaticValueArray;
    mJsClassDef.staticFunctions = NULL;
    mJsClassDef.initialize = NULL;
    mJsClassDef.finalize = TKJSBasicCell::jsFinalize;
    mJsClassDef.hasProperty = NULL;
    mJsClassDef.getProperty = NULL;
    mJsClassDef.setProperty = NULL;
    mJsClassDef.deleteProperty = NULL;
    mJsClassDef.getPropertyNames = NULL;
    mJsClassDef.callAsFunction = NULL;
    mJsClassDef.callAsConstructor = NULL;
    mJsClassDef.hasInstance = NULL;
    mJsClassDef.convertToType = NULL;

    mJSAPIClass = JSClassCreate(&mJsClassDef);
    JSClassRetain(mJSAPIClass);

    mJsstrReceptors = JSStringCreateWithUTF8CString("receptors");

    msLock.unlock();
}


JSValueRef TKJSBasicCell::jsAPICB_getAxonValue(
                                               JSContextRef ctx,
                                               JSObjectRef object,
                                               JSStringRef propertyName,
                                               JSValueRef *exception)
{	
    TKJSBasicCell *self = (TKJSBasicCell*)JSObjectGetPrivate(object);
    TKASSERT(self);
#ifdef DEBUG    
    DEBUG_TRACE("CELL:%s CELLAPI getAxonValue\n", self->getName().c_str());
#endif
    return JSValueMakeNumber(ctx, self->getAxonValue());
}

bool TKJSBasicCell::jsAPICB_setAxonValue(
                                         JSContextRef ctx,
                                         JSObjectRef object,
                                         JSStringRef propertyName,
                                         JSValueRef value,
                                         JSValueRef *exception)
{	
    TKJSBasicCell *self = (TKJSBasicCell*)JSObjectGetPrivate(object);
    TKASSERT(self);
#ifdef DEBUG
    DEBUG_TRACE("CELL:%s CELLAPI setAxonValue\n", self->getName().c_str());
#endif
    self->setAxonValue(JSValueToNumber(ctx, value, exception));
	
    return true;
}

JSValueRef TKJSBasicCell::jsAPICB_getName(
                                            JSContextRef ctx,
                                            JSObjectRef object,
                                            JSStringRef propertyName,
                                            JSValueRef *exception)
{
    TKJSBasicCell *self = (TKJSBasicCell*)JSObjectGetPrivate(object);
    TKASSERT(self);
    return self->mJName;
}

JSValueRef TKJSBasicCell::jsAPICB_getLocation(
                                          JSContextRef ctx,
                                          JSObjectRef object,
                                          JSStringRef propertyName,
                                          JSValueRef *exception)
{
    TKJSBasicCell *self = (TKJSBasicCell*)JSObjectGetPrivate(object);
    TKASSERT(self);
    return self->mJLocation;
}

void TKJSBasicCell::jsFinalize(JSObjectRef object)
{
    TKJSBasicCell *self = (TKJSBasicCell*)JSObjectGetPrivate(object);
    TKASSERT(self);
}

