//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 1/7/2012.
//

#ifndef dennco_DNTimeKeeper_h
#define dennco_DNTimeKeeper_h

class DNTimeKeeperImpl;

class DNTimeKeeper
{
public:
    DNTimeKeeper();
    ~DNTimeKeeper();
    
    static const int    STATE_IN_FULL_SCAN_TIME;
    static const int    STATE_IN_SIGNAL_SCAN_TIME;
    static const int    STATE_IN_INPUT_SCAN_TIME;
    static const int    STATE_IN_OUTPUT_SCAN_TIME;

    bool                setIntevalSec(float full, float signal, float input, float output);
    int                 sleepUntilNextInterval();
    float               getTickTime();
  
    bool                start();
    bool                stop();
    
private:
    DNTimeKeeperImpl    *impl;
};

#endif
