//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 1/7/2012.
//

#include "DNTimeKeeperImpl.h"

#include "DNTimeKeeper.h"

const int DNTimeKeeper::STATE_IN_FULL_SCAN_TIME      = 0x01;
const int DNTimeKeeper::STATE_IN_SIGNAL_SCAN_TIME    = 0x02;
const int DNTimeKeeper::STATE_IN_INPUT_SCAN_TIME     = 0x04;
const int DNTimeKeeper::STATE_IN_OUTPUT_SCAN_TIME    = 0x08;

DNTimeKeeper::DNTimeKeeper()
{
    impl = DNTimeKeeperImpl::create();
}

DNTimeKeeper::~DNTimeKeeper()
{
    if (impl)
        delete impl;
}

bool DNTimeKeeper::setIntevalSec(float full, float signal, float input, float output)
{
    return impl->setIntevalSec(full, signal, input, output);
}

int DNTimeKeeper::sleepUntilNextInterval()
{
    return impl->sleepUntilNextInterval();
}

float DNTimeKeeper::getTickTime()
{
    return impl->getTickTime();
}

bool DNTimeKeeper::start()
{
    return impl->start();
}

bool DNTimeKeeper::stop()
{
    return impl->start();
}
