//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 12/11/2011.
//

#include "TKAxonTerminal.h"
#include "TKReceptor.h"
#include "TKCell.h"
#include "TKAxon.h"
#include "TKLog.h"

bool TKReceptor::update()
{
    if (mTerminal)
    {
        float newValue = mTerminal->getValue();
        if (newValue != mValue)
        {
            mValue = newValue;
            return true;
        }
    }
    return false;
}

float TKReceptor::getValue()
{
#ifdef DEBUG_CONNECTION
    TKLog::debugPrintf("TKReceptor::getValue called: owner:%s  tarminal owner:%s value:%f\n",
                  mOwner->getName().c_str(), 
                  mTerminal->getOwner()->getOwner()->getName().c_str(),
                  mValue;
#endif
    return mValue;
}

void TKReceptor::setTarget(TKAxonTerminal *theTerminal)
{
    if (mTerminal)
    {
        mTerminal->release(this);
    }
    mTerminal = theTerminal;
    mTerminal->setTarget(this);
}

