//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 12/21/2011.
//

#ifndef __INCLUDE_TKCELLCODEINSTANCE__
#define __INCLUDE_TKCELLCODEINSTANCE__

class TKCell;

class TKCellCodeInstance
{
public:
    inline TKCell* getOwner() { return mOwner; }

    TKCellCodeInstance(TKCell *owner) : mOwner(owner) {}
    virtual ~TKCellCodeInstance() {}
    
    virtual bool doTick(float time) = 0;
    virtual bool doInit() = 0;
    virtual bool doDestroy() = 0;

    
    
private:
    TKCell *mOwner;
    
};


#endif
