

#include "ndngesturevision.h"

#include <opencv2/opencv.hpp>

int main()
{

    cv::VideoCapture cap(0); // open the default camera
    if(!cap.isOpened())  // check if we succeeded
        return -1;

//    cap.set(CV_CAP_PROP_FRAME_WIDTH, 320);
//    cap.set(CV_CAP_PROP_FRAME_HEIGHT, 240);

    cv::Mat frame;
    cv::Mat calcFrame;

    cv::Size calcSize(320,240);
    NDNGestureVision *gestureVision = new NDNGestureVision(calcSize.width, calcSize.height);

    std::string winName = "Motion";
    cv::namedWindow( winName,  CV_WINDOW_AUTOSIZE );

    while(true)
    {
        cap >> frame;
        cv::resize(frame, calcFrame, calcSize);
        gestureVision->calculateFlow(calcFrame, &calcFrame);

        cv::imshow( winName, calcFrame );
        if(cv::waitKey(30) >= 0) break;
    }
}
