// Copyright yaneurao 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include "yaneElapseTime.h"
#include "yaneGameTime.h"

#pragma comment(lib,"winmm.lib")
#include <mmsystem.h>

CElapseTime::CElapseTime(void) {
    SetFPS(60); // fBtHgl̐ݒ

    // timeGetTime̎グ邩Himsł1msۏ؂ĂȂj
    // ܂AňAe̗L肻Ȃ̂́ADrawSceneȂ񂾂...
}

CElapseTime::~CElapseTime() {
    //  fXgN^ł͓ɏ͂Ȃ
}

void CElapseTime::SetFPS(DWORD fps){ // FPSl
    ResetTimer();
    ResetElapseTimeCounter();

	m_dwCallCount = 0;
	m_nUnuseSleep = 0;
    m_nDrawCount  = 0;

    m_dwFPS = fps;
    if (fps==0) {   // non-wait mode
        return ;
    }
    
    // Pt[Ƃɉms҂Kv̂H~0x10000[ms]
    m_dwFPSWait = (1000*0x10000)/m_dwFPS;
    
    // ́AdwFPSWait̏ȉ8rbg̐xŕێ邽߂ɂ
    m_dwFPSWaitTT = 0; //@̎Ԃ̓[(cf.DrawFlip)
}

DWORD CElapseTime::GetFPS(void) {
    return m_dwFPS;
}

void CElapseTime::ResetTimer(void){
    m_dwLastDraw = CTimeBase::timeGetTime(); // O`掞Ԃ́AŐݒ
}

void CElapseTime::ResetElapseTimeCounter(void){     // ElapseTimeJE^̃Zbg
	m_dwElapsedTime = 0;
}

DWORD CElapseTime::GetElapseTimeCounter(void){  // ElapseTimeJE^̎擾
    return m_dwElapsedTime;
}

void CElapseTime::ResetCallCounter(void){    // ďoJE^̃Zbg
	m_dwCallCount = 0;
}

DWORD CElapseTime::GetCallCounter(void){	 // ďoJE^̎擾
    return m_dwCallCount;
}
// ---------------------------------------------------------------------------

void CElapseTime::WaitFrame(void){   // (C)yaneurao 1998-1999
    DWORD t = CTimeBase::timeGetTime(); // ݎ

    m_dwDrawTime[m_nDrawCount & 15] = t;  // DrawԂL^邱ƂFPSZo菕ɂ
    if (++m_nDrawCount == 32) m_nDrawCount = 16;
    // 8ɖ߂ƂɂāA0`15ȂA܂16t[̕`悪IĂȂ߁A
    // FPS̎ZooȂƂm邱ƂoB

    m_dwCallCount++; // FPSɎgƂoB

    // Ȃ茵lmǂԑ҂͂B
    if (m_dwFPS == 0) {
		m_dwElapseTime[m_nDrawCount & 15] = 0;
		return ; // Non-wait mode
	}

    m_dwFPSWaitTT = (m_dwFPSWaitTT & 0xffff) + m_dwFPSWait; // ̑҂ԂvZ
    // m_dwFPSWait́A҂Ԃ̏ȉPUrbg̐xŎĂƍl
    // ɂAdouble^oKvȂȂB

    DWORD dwWait = m_dwFPSWaitTT >> 16; // ǂ̂ƂA͉ms҂˂H

    // Pt[Ԃo߂Bɕ`悵ȂႢI
    DWORD dwElp = (DWORD)(t - m_dwLastDraw); // O`悩炢o߂Ƃ˂H
    if (dwElp>=dwWait) { // ߂ĂI߂Ă镪A7ms܂ł玟ɎzŁI
        if ((dwElp-dwWait) < 7) { t -= (dwElp-dwWait); } else { t -= 7; }
        // ̕`掞U邱ƂŁA̕`Jn𑁂߂
        m_dwLastDraw = t;
		m_dwElapseTime[m_nDrawCount & 15] = 0;
        return ;
    }

    // قȁAԂׂƂI

    m_dwElapsedTime += dwElp; // ԑ҂ƂČv
	m_dwElapseTime[m_nDrawCount & 15] = dwElp;

    // ܂Ԃ͂Ղ肠̂H
    // 4msȏKv̂Ȃ΁ASleep
    // dwWait>dwElpȂ̂dwWait-dwElp>=0ƍlėǂ
    if (dwWait-dwElp >= 4) {
        if (m_nUnuseSleep) {
            m_nUnuseSleep--;
        } else {
            Sleep(dwWait-dwElp-3);
        }
    }

    // 95/98/NTő肵ƂSleep(1);1msPʂŃX[v͉̂\
    // Anˑ̉\̂Sleep̐x3msȓƉ   

    if ((CTimeBase::timeGetTime()-m_dwLastDraw)>=dwWait) {
    // ׁ[IIQ߂Ƃ񂯁IIi΁j
        m_nUnuseSleep = 60; // 60t[Sleepg͂...
        // AȂ񂿂[_oȃvOȂ...
        m_dwLastDraw += dwWait; // Q߂Ă[ǖ:p
        return ;
    }

    while ((CTimeBase::timeGetTime()-m_dwLastDraw)<dwWait) ;
    // [vŎԂׂi܂DȂǁj

    // ŁAԂԂI

    m_dwLastDraw += dwWait; // ҂ŕ`悪肷Bi[܂Ȃ߁j
}


DWORD CElapseTime::GetRealFPS(void) {  //  FPS̎擾ilj

    if (m_nDrawCount < 16) return 0; // ܂16t[vĂȂ
    DWORD t = m_dwDrawTime[(m_nDrawCount-1) & 15] // O񎞊
            -   m_dwDrawTime[m_nDrawCount & 15];     // 15O̎

    if(t==0) return 0;

    return 1000*15/t; // ςZoĒlԂ

}

DWORD CElapseTime::GetCPUPower(void) {  //  CPU Power̎擾ilj

    if (m_nDrawCount < 16) return 0; // ܂16t[vĂȂ
	DWORD t=0;
	for(int i=0;i<16;i++) 
		t += m_dwElapseTime[i]; // 16t[Elapse
	// return 1-t/(1000*16/m_dwFPS)[%] ; // FPSm}ZoĒlԂ
	return 100-(t*m_dwFPS/160);
}
