//
// ȃZ`
//

// Copyright Delight Delight Reduplication Development Project 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#ifndef __SelectMusic__
#define __SelectMusic__

#include "CScene.h"
#include "CGlobalScene.h"
#include "DirectDraw.h"
#include "DirectSound.h"
#include "DirectPlay.h"

#include "yaneCDDA.h"
//#include "yaneGameTime.h"
#include "yaneTimer.h"
#include "yaneDirectInput.h"
#include "yaneRand.h"

#include "VKey.h"
#include "structs.h"
#include "consts.h"
#include "CMove.h"
#include "CScore.h"

#include <mmsystem.h>
#include <math.h>
#include <time.h>

#include <vector>
using namespace std;

#define random(n)		( ::rnd.Get(n) )

#define KEYPUSH(vkey)	(VKey.IsVKeyPushDown(vkey))
#define KEYPRESS(vkey)	(VKey.IsVKeyPress(vkey))

#define RANGE(x,l,h)	((x) = ((x)<(l)?(l):(x)>(h)?(h):(x)))

// oOC
#define LOOP(x,a,b)		((x) = ((x)<(a) ? (b)-((a)+(((-(x)-1)%((b)-(a)+1)))) : ((b)<(x) ? (a)+((((x)-(b)-1)%((b)-(a)+1))) : (x))) ) // a-b̊ԂŃ[v(p)//-(b)
//#define ABS(x)			((x)>0 ? (x) : -(x))

class CSelectMusic : public CScene {

private:

	static const int HEAD_MARGIN		= 30; // ʏ㕔̋󂫃Xy[X

	static const int LIST_WIDTH			= 140; // ȕ̍ƕ
	static const int LIST_HEIGHT		= 17;
	static const int LIST_MUSICNUM		= 30; // Xgɕ\Ȑ
	static const int LIST_SELECTEDNUM	= 12; // ォ牽ȖڂIĂ邩(O琔)

	static const int DIFF_LIST_ROWS = 7; // ՓxI̗̐
	static const int JUKE_LIST_ROWS	= 15;

	static const int NEW_TIME	= 3600 * 24 * 3; // VȂ̐Fς(b) CMusicListSortłgĂ܂̂œ
	static const COLORREF NEW_COLOR	= RGB(255,255,0);//RGB(241, 194, 64); //RGB(0,255,255),

	static const int JUKELIST_INTIME	= 500;  // JukeXg̃XChCɂ鎞
	static const int JUKELIST_DISPTIME  = 2000; // JukeXgSɕ\Ă鎞
	static const int JUKELIST_OUTTIME   = 500;  // JukeXg̃XChAEgɂ鎞

	// EBhẼXChCIĂ邱Ƃۏ؂鎞
	// ̊Ԃ͋ȖwǐuH_łNȂ
	static const int NOT_BLINK_TIME = 1000;

	CTimer m_NotBlink;

	// C
	void DrawTitle(int x, int y);

	void DrawMusicList(int x, int y, int mode);

	void DrawDiffList(int x, int y, int mode);
	void DrawDiffItem(int x, int y, int diffPos, BOOL bDrawCursor);
	void DrawMusicInfo(int x, int y);

	void DrawCfgMenu(int x, int y, int mode);

	void DrawSelectedMusic(int x, int y, int mode);
	enum
	{
		DML_SLIDEIN	 = 0,
		DML_SLIDEOUT = 1,
		DML_RESET	 = 2,
	};

	// Ȃ߂炩XN[A[ł̃[v
	void DrawScrollBarMusic(int x, int y, int dx, int dy);

	// iKIXN[A[vȂ
	void DrawScrollBarSimple(int start, int end, int rowNum, int x, int y, int dx, int dy);

	void DrawScoreWindow(void);

	BOOL LoadStageFile(void);
	void DrawStageFile(BOOL bBlack); // StageFileȂƂbBlack=TRUEɂƍh

	// vC}obt@ɒڏދ̂B
	// GtFNgxƂɂ͂g
	void DrawStageFileClassic(void);

	void KeyCheck(void);
	void KeyCheckMusicSelect(void); // J[\ȑIɂƂ̃L[
	void KeyCheckDiffSelect(void);

	void PlayShortBGM(int folPos, int curPos);

	// Tu
	DWORD DrawDigit(int spNumBase, int x, int y, DWORD num, BOOL bDraw = TRUE);
	void SetFont(HDC hDC, const char* fontname, int height, BOOL bJapanese, BOOL bBold);
	void ReleaseFont(HDC hDC);
	BOOL IsDBCS(const char* str);
	void CalcPos(int& x, int& y, int i, int mode, int count);
	void SortDataSet(void);
	void SortData(void);
	void PlayOptionToText(PLAY_OPTION* opt, char* buf);
	void CalcSelectedMusicCRC(void);

	void WriteScoreFromDB(void);

	BOOL LoadBMP(void);
	void UnLoadBMP(void);

	BOOL LoadMusic(void);
	void StartMusic(void);

	// qsortpr֐
	static int CompareTitle (const void *arg1, const void *arg2);
	static int CompareArtist(const void *arg1, const void *arg2);
	static int CompareGenre (const void *arg1, const void *arg2);
	static int CompareLevel (const void *arg1, const void *arg2);

	HFONT m_OldFont;

	static int m_curPos; // MUSIC SET̃J[\ʒu
	static vector<int> m_curPosRec; // curPosLpBێgƂon demandŊg
	static int m_diffPos; // MUSIC SETɊ܂܂Ȃ̃J[\ʒu

	static int m_menuPos; // JukeList/IvVj[̃J[\ʒu
	static const int MP_JUKE = 0;
	static const int MP_SYSOPT = 1; // System Option
	static const int MP_COMOPT = 2; // Common Option
	static const int MP_MODEOPT = 3; // BM & DDR Option

	BOOL m_bRndDecide; // _ZNĝƂpBTRUEȂ玟̃t[ŋȃX^[g

	BOOL m_bStartMusic; // {^āAEBhEނƂ̓ɓĂ

	BOOL m_showStageFile; // ʂ
	static const int STAGEFILE_BMPNUM = 356; // StageFileBMPԍ
	static const int STAGEFILE_SPNUM = 356; // StageFileSpriteԍ

	CTimer m_StartMusicTime; // {^ꂽ̌oߎ
	static const int STARTMUSIC_TIME = 1500; // EBhEރGtFNgI鎞

	static int m_dif; // ݑIĂMSD̃[h(p~\)

	CTimer m_sortDispTime; // \[g[h̕\ԃ^C}[
	static const int SORT_DISPTIME = 3000; // \
	static int m_sortDataSetMode; // Dataset\[g郂[hB0:None 1:Title 2:ScanTime
	static int m_sortMode; // 0:None 1:Title 2:Artist 3:Genre 4:Level 5:ScanTime

	double m_yPos; // ȃXgXN[ItZbg
	double m_xPos; // JukeXgXN[ItZbg
	float m_alpha; // _ŗpʃl

	BOOL m_bScoreDisp; // XRȀڍו\EBhEJĂ邩ǂ

	static DWORD m_menuMode; // ݂ǂ̃j[ɂ̂
	static const int MM_SELMUSIC = 0; // IȃEBhE
	static const int MM_SELDIFF  = 1; // ՓxIEBhE
	static const int MM_PLAYOPT  = 2; // 7łvCIvV
	static const int MM_CONFIG   = 3; // ɏoĂIvV
	static const int MM_CONFIG2  = 4; // ɏoĂIvV̏ڍ׍

	// 1,2L[莞JukeXgXChC
	CTimer m_JukeWndDisp;


	// J[\~߂ԁBHOLD_TIMEOUT𒴂
	// J[\ʒũt@CCRCvZXRA\
	enum { HOLD_TIMEOUT = 500 };
	CTimer m_holdTime;

	// BMPԍ萔B
	// 65-79܂BMP󂢂Ă܂
	// ₵UnLoadBMP̏CYȂ悤ɁI
	static const int background					= 65;
	static const int background_title			= 66; // ꂾDrawSelectedMusicɃRsyBv
	static const int background_playoption		= 67;
	static const int window_configulation		= 68;
	static const int window_selectfile			= 69;
	static const int window_selectdifficulty	= 70;
	static const int window_current_select		= 71;
	static const int frame_top_bottom			= 72;
	static const int font_number				= 73;
	static const int difficulty					= 74;
	static const int information				= 75;
	static const int lines						= 76;
	static const int playable					= 77;
	static const int player						= 78;

	// XvCgԍ萔B
	// 420-429, 450-499, 600-609, 1310-1329܂ŃXvCg󂢂Ă܂
	static const int sp_bg						= 450;
	static const int sp_background_title_dots	= 451;
	static const int sp_playopt_green_base		= 452; // 452-458
	static const int sp_playopt_blue_base		= 459; // 459-465
	static const int sp_background_title_base	= 466; // 466,467
	static const int sp_wnd_conf				= 468;
	static const int sp_wnd_selfile				= 469;
	static const int sp_wnd_seldiff				= 470;
	static const int sp_frame_top				= 471;
	static const int sp_frame_bottom			= 472;
	static const int sp_bpm_font_base			= 473; // 473-482
	static const int sp_bpm						= 483;
	static const int sp_difficulty_base			= 484; // 484-488
	static const int sp_info_player_base		= 489; // 489-492
	static const int sp_info_lines_base			= 493; // 493-496
	static const int sp_info_bga_base			= 497; // 497-498
	static const int sp_playable				= 499;
	static const int sp_info_level_base			= 420; // 420-424(󂫂Ȃ̂łȂƂc)

	static const int sp_lines_base				= 426; // 426-429

	static const int sp_diff_num_base			= 600; // 600-609
	static const int sp_diff_num_mini_base		= 1310; // 1310-1319
	static const int sp_listbox_music_nonsel	= 1320;
	static const int sp_listbox_music_sel		= 1321;
	static const int sp_listbox_diff_nonsel		= 1322;
	static const int sp_listbox_diff_sel		= 1323;
	static const int sp_listbox_conf_nonsel_s	= 1324;
	static const int sp_listbox_conf_sel_s		= 1325;
	static const int sp_listbox_conf_nonsel_l	= 1326;
	static const int sp_listbox_conf_sel_l		= 1327;
	static const int sp_player_base				= 1328; // 1328,1329

public:

	CSelectMusic();
	~CSelectMusic();

	BOOL Init(CGlobalData* lpgd);
	BOOL Term(void);
	void ProcessFrame(void);

};

#endif